package com.temboo.Library.Google.Drive.Files;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
Insert

Inserts a new file.
*/
public class Insert extends Choreography {

	/**
	Create a new instance of the Insert Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public Insert(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Google/Drive/Files/Insert"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return InsertInputSet
	*/
	public InsertInputSet newInputSet() {
		return new InsertInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public InsertResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new InsertResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the Insert
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class InsertInputSet extends InputSet {
		/** 
		Set the value of the RequestBody input for this Choreo. 

		@param String - (conditional, json) A JSON representation of fields in a file resource. File metadata information (such as the title) can be inserted using this input. See documentation for formatting examples.
		*/
		public void set_RequestBody(String value) {
			this.setInput("RequestBody", value);
		}


		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (optional, string) A valid access token retrieved during the OAuth2 process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the ClientID input for this Choreo. 

		@param String - (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
		*/
		public void set_ClientID(String value) {
			this.setInput("ClientID", value);
		}


		/** 
		Set the value of the ClientSecret input for this Choreo. 

		@param String - (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
		*/
		public void set_ClientSecret(String value) {
			this.setInput("ClientSecret", value);
		}


		/** 
		Set the value of the ContentType input for this Choreo. 

		@param String - (conditional, string) The Content-Type of the file that is being uploaded (i.e. image/jpg). Required when specifying the FileContent input.
		*/
		public void set_ContentType(String value) {
			this.setInput("ContentType", value);
		}


		/** 
		Set the value of the Convert input for this Choreo. 

		@param Boolean - (optional, boolean) Whether to convert this file to the corresponding Google Docs format. (Default: false).
		*/
		public void set_Convert(Boolean value) {
			this.setInput("Convert", value);
		}

		/** 
		Set the value of the Convert input for this Choreo as a String. 

		@param String - (optional, boolean) Whether to convert this file to the corresponding Google Docs format. (Default: false).
		*/
		public void set_Convert(String value) {
			this.setInput("Convert", value);	
		}
		/** 
		Set the value of the Fields input for this Choreo. 

		@param String - (optional, string) Selector specifying a subset of fields to include in the response.
		*/
		public void set_Fields(String value) {
			this.setInput("Fields", value);
		}


		/** 
		Set the value of the FileContent input for this Choreo. 

		@param String - (conditional, string) The Base64 encoded contents of the file to upload.
		*/
		public void set_FileContent(String value) {
			this.setInput("FileContent", value);
		}


		/** 
		Set the value of the OCR input for this Choreo. 

		@param Boolean - (optional, boolean) Whether to attempt OCR on .jpg, .png, .gif, or .pdf uploads. (Default: false)
		*/
		public void set_OCR(Boolean value) {
			this.setInput("OCR", value);
		}

		/** 
		Set the value of the OCR input for this Choreo as a String. 

		@param String - (optional, boolean) Whether to attempt OCR on .jpg, .png, .gif, or .pdf uploads. (Default: false)
		*/
		public void set_OCR(String value) {
			this.setInput("OCR", value);	
		}
		/** 
		Set the value of the OcrLanguage input for this Choreo. 

		@param String - (optional, string) If ocr is true, hints at the language to use. Valid values are ISO 639-1 codes.
		*/
		public void set_OcrLanguage(String value) {
			this.setInput("OcrLanguage", value);
		}


		/** 
		Set the value of the Pinned input for this Choreo. 

		@param Boolean - (optional, boolean) Whether to pin the head revision of the uploaded file. (Default: false).
		*/
		public void set_Pinned(Boolean value) {
			this.setInput("Pinned", value);
		}

		/** 
		Set the value of the Pinned input for this Choreo as a String. 

		@param String - (optional, boolean) Whether to pin the head revision of the uploaded file. (Default: false).
		*/
		public void set_Pinned(String value) {
			this.setInput("Pinned", value);	
		}
		/** 
		Set the value of the RefreshToken input for this Choreo. 

		@param String - (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
		*/
		public void set_RefreshToken(String value) {
			this.setInput("RefreshToken", value);
		}


		/** 
		Set the value of the SourceLanguage input for this Choreo. 

		@param String - (optional, string) The language of the original file to be translated.
		*/
		public void set_SourceLanguage(String value) {
			this.setInput("SourceLanguage", value);
		}


		/** 
		Set the value of the TargetLanguage input for this Choreo. 

		@param String - (optional, string) Target language to translate the file to. If no sourceLanguage is provided, the API will attempt to detect the language.
		*/
		public void set_TargetLanguage(String value) {
			this.setInput("TargetLanguage", value);
		}


		/** 
		Set the value of the TimedTextLanguage input for this Choreo. 

		@param String - (optional, string) The language of the timed text.
		*/
		public void set_TimedTextLanguage(String value) {
			this.setInput("TimedTextLanguage", value);
		}


		/** 
		Set the value of the TimedTextTrackName input for this Choreo. 

		@param String - (optional, string) The timed text track name.
		*/
		public void set_TimedTextTrackName(String value) {
			this.setInput("TimedTextTrackName", value);
		}


		/** 
		Set the value of the VaultFile input for this Choreo. 

		@param TembooPath - A path to a vault file to upload. This can be used as an alternative to the FileContent input.
		*/

	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the Insert Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class InsertResultSet extends ResultSet {
		public InsertResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "NewAccessToken" output from this Choreo execution

		@return String - (string) Contains a new AccessToken when the RefreshToken is provided.
		*/
		public String get_NewAccessToken() {
			return this.getResultString("NewAccessToken");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Google.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
