package com.temboo.Library.Google.BigQuery.TableData;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
InsertAll

Streams data into BigQuery one record at a time.
*/
public class InsertAll extends Choreography {

	/**
	Create a new instance of the InsertAll Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public InsertAll(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Google/BigQuery/TableData/InsertAll"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return InsertAllInputSet
	*/
	public InsertAllInputSet newInputSet() {
		return new InsertAllInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public InsertAllResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new InsertAllResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the InsertAll
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class InsertAllInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (optional, string) A valid Access Token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new Access Token.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the ClientID input for this Choreo. 

		@param String - (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
		*/
		public void set_ClientID(String value) {
			this.setInput("ClientID", value);
		}


		/** 
		Set the value of the ClientSecret input for this Choreo. 

		@param String - (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
		*/
		public void set_ClientSecret(String value) {
			this.setInput("ClientSecret", value);
		}


		/** 
		Set the value of the DatasetID input for this Choreo. 

		@param String - (required, string) The ID of the dataset that your table belongs to.
		*/
		public void set_DatasetID(String value) {
			this.setInput("DatasetID", value);
		}


		/** 
		Set the value of the Fields input for this Choreo. 

		@param String - (optional, string) Selector specifying which fields to include in a partial response.
		*/
		public void set_Fields(String value) {
			this.setInput("Fields", value);
		}


		/** 
		Set the value of the IgnoreUnknownValues input for this Choreo. 

		@param Boolean - (optional, boolean) Accept rows that contain values that do not match the schema. The unknown values are ignored. Default is false, which treats unknown values as errors.
		*/
		public void set_IgnoreUnknownValues(Boolean value) {
			this.setInput("IgnoreUnknownValues", value);
		}

		/** 
		Set the value of the IgnoreUnknownValues input for this Choreo as a String. 

		@param String - (optional, boolean) Accept rows that contain values that do not match the schema. The unknown values are ignored. Default is false, which treats unknown values as errors.
		*/
		public void set_IgnoreUnknownValues(String value) {
			this.setInput("IgnoreUnknownValues", value);	
		}
		/** 
		Set the value of the ProjectID input for this Choreo. 

		@param String - (required, string) The ID of your Google API project.
		*/
		public void set_ProjectID(String value) {
			this.setInput("ProjectID", value);
		}


		/** 
		Set the value of the RefreshToken input for this Choreo. 

		@param String - (conditional, string) An OAuth Refresh Token used to generate a new Access Token when the original token is expired. Required unless providing a valid AccessToken.
		*/
		public void set_RefreshToken(String value) {
			this.setInput("RefreshToken", value);
		}


		/** 
		Set the value of the Rows input for this Choreo. 

		@param String - (conditional, json) The rows to insert. This should be a JSON array containing at least one object representing a row. See Choreo notes for formatting details.
		*/
		public void set_Rows(String value) {
			this.setInput("Rows", value);
		}


		/** 
		Set the value of the TableID input for this Choreo. 

		@param String - (required, string) The ID of the BigQuery table to insert a row into.
		*/
		public void set_TableID(String value) {
			this.setInput("TableID", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the InsertAll Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class InsertAllResultSet extends ResultSet {
		public InsertAllResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "NewAccessToken" output from this Choreo execution

		@return String - (string) Contains a new AccessToken when the RefreshToken is provided.
		*/
		public String get_NewAccessToken() {
			return this.getResultString("NewAccessToken");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Google.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
