package com.temboo.Library.Google.Analytics;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetMetrics

Retrieves metrics such as visits, page views, bounces within a specified time frame.
*/
public class GetMetrics extends Choreography {

	/**
	Create a new instance of the GetMetrics Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetMetrics(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Google/Analytics/GetMetrics"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetMetricsInputSet
	*/
	public GetMetricsInputSet newInputSet() {
		return new GetMetricsInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetMetricsResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetMetricsResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetMetrics
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetMetricsInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (optional, string) A valid Access Token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new Access Token.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the ClientID input for this Choreo. 

		@param String - (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
		*/
		public void set_ClientID(String value) {
			this.setInput("ClientID", value);
		}


		/** 
		Set the value of the ClientSecret input for this Choreo. 

		@param String - (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
		*/
		public void set_ClientSecret(String value) {
			this.setInput("ClientSecret", value);
		}


		/** 
		Set the value of the Dimensions input for this Choreo. 

		@param String - (optional, string) Defines the primary data keys for your Analytics report. Use dimensions to segment your web property metrics (e.g.  ga:browser or ga:city).
		*/
		public void set_Dimensions(String value) {
			this.setInput("Dimensions", value);
		}


		/** 
		Set the value of the EndDate input for this Choreo. 

		@param String - (required, date) The end date for the range of data you want to retrieve. Epoch timestamp in milliseconds or formatted as yyyy-MM-dd.
		*/
		public void set_EndDate(String value) {
			this.setInput("EndDate", value);
		}


		/** 
		Set the value of the Filters input for this Choreo. 

		@param String - (optional, string) Restricts the data returned by a dimension or metric you want to filter by using an expression (i.e. ga:timeOnPage==10).
		*/
		public void set_Filters(String value) {
			this.setInput("Filters", value);
		}


		/** 
		Set the value of the MaxResults input for this Choreo. 

		@param Integer - (optional, integer) The max results to be returned in the feed. Defaults to 50.
		*/
		public void set_MaxResults(Integer value) {
			this.setInput("MaxResults", value);
		}

		/** 
		Set the value of the MaxResults input for this Choreo as a String. 

		@param String - (optional, integer) The max results to be returned in the feed. Defaults to 50.
		*/
		public void set_MaxResults(String value) {
			this.setInput("MaxResults", value);	
		}
		/** 
		Set the value of the Metrics input for this Choreo. 

		@param String - (optional, string) This is a comma separated list of metrics you want to retrieve. Defaults to: ga:visits,ga:bounces,ga:pageviews.
		*/
		public void set_Metrics(String value) {
			this.setInput("Metrics", value);
		}


		/** 
		Set the value of the Password input for this Choreo. 

		@param String - (required, password) Deprecated (retained for backward compatibility only).
		*/
		public void set_Password(String value) {
			this.setInput("Password", value);
		}


		/** 
		Set the value of the ProfileId input for this Choreo. 

		@param Integer - (required, integer) The Google Analytics Profile ID to access. This is also known as the View ID. It can be found in the Admin > View Settings section of a particular profile.
		*/
		public void set_ProfileId(Integer value) {
			this.setInput("ProfileId", value);
		}

		/** 
		Set the value of the ProfileId input for this Choreo as a String. 

		@param String - (required, integer) The Google Analytics Profile ID to access. This is also known as the View ID. It can be found in the Admin > View Settings section of a particular profile.
		*/
		public void set_ProfileId(String value) {
			this.setInput("ProfileId", value);	
		}
		/** 
		Set the value of the RefreshToken input for this Choreo. 

		@param String - (conditional, string) An OAuth Refresh Token used to generate a new Access Token when the original token is expired. Required unless providing a valid AccessToken.
		*/
		public void set_RefreshToken(String value) {
			this.setInput("RefreshToken", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are: XML (the default) and JSON.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the Segment input for this Choreo. 

		@param String - (optional, string) Used to segment your data by dimensions and/or metrics. You can use expressions for segments just as you would for the Filters parameter.
		*/
		public void set_Segment(String value) {
			this.setInput("Segment", value);
		}


		/** 
		Set the value of the Sort input for this Choreo. 

		@param String - (optional, string) Indicates the sorting order and direction for the returned data. Values can be separated by commas (i.e. ga:browser,ga:pageviews).
		*/
		public void set_Sort(String value) {
			this.setInput("Sort", value);
		}


		/** 
		Set the value of the StartDate input for this Choreo. 

		@param String - (required, date) The start date for the range of data to retrieve. Use epoch timestamp in milliseconds or formatted as yyyy-MM-dd.
		*/
		public void set_StartDate(String value) {
			this.setInput("StartDate", value);
		}


		/** 
		Set the value of the StartIndex input for this Choreo. 

		@param Integer - (optional, integer) The starting entry for the feed. Defaults to 1.
		*/
		public void set_StartIndex(Integer value) {
			this.setInput("StartIndex", value);
		}

		/** 
		Set the value of the StartIndex input for this Choreo as a String. 

		@param String - (optional, integer) The starting entry for the feed. Defaults to 1.
		*/
		public void set_StartIndex(String value) {
			this.setInput("StartIndex", value);	
		}
		/** 
		Set the value of the Username input for this Choreo. 

		@param String - (required, string) Deprecated (retained for backward compatibility only).
		*/
		public void set_Username(String value) {
			this.setInput("Username", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetMetrics Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetMetricsResultSet extends ResultSet {
		public GetMetricsResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Bounces" output from this Choreo execution

		@return String - (integer) The bounces metrics parsed from the Google Analytics response
		*/
		public String get_Bounces() {
			return this.getResultString("Bounces");
		}
		/** 
		Retrieve the value for the "NewAccessToken" output from this Choreo execution

		@return String - (string) Contains a new AccessToken when the RefreshToken is provided.
		*/
		public String get_NewAccessToken() {
			return this.getResultString("NewAccessToken");
		}
		/** 
		Retrieve the value for the "PageViews" output from this Choreo execution

		@return String - (integer) The page views parsed from the Google Analytics response
		*/
		public String get_PageViews() {
			return this.getResultString("PageViews");
		}
		/** 
		Retrieve the value for the "Visits" output from this Choreo execution

		@return String - (integer) The visits metrics parsed from the Google Analytics response.
		*/
		public String get_Visits() {
			return this.getResultString("Visits");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Google.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
