package com.temboo.Library.DarkSky;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
TimeMachineRequest

Returns the observed (in the past) or forecasted (in the future) hour-by-hour weather and daily weather conditions for a particular date.
*/
public class TimeMachineRequest extends Choreography {

	/**
	Create a new instance of the TimeMachineRequest Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public TimeMachineRequest(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/DarkSky/TimeMachineRequest"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return TimeMachineRequestInputSet
	*/
	public TimeMachineRequestInputSet newInputSet() {
		return new TimeMachineRequestInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public TimeMachineRequestResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new TimeMachineRequestResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the TimeMachineRequest
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class TimeMachineRequestInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key provided by Dark Sky.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the Exclude input for this Choreo. 

		@param String - (optional, string) Exclude some number of data blocks from the API response. Valid values are: currently, minutely, hourly, daily, alerts, and flags.
		*/
		public void set_Exclude(String value) {
			this.setInput("Exclude", value);
		}


		/** 
		Set the value of the Extend input for this Choreo. 

		@param String - (optional, string) When present, returns hour-by-hour data for the next 168 hours, instead of the next 48. Valid value: hourly.
		*/
		public void set_Extend(String value) {
			this.setInput("Extend", value);
		}


		/** 
		Set the value of the Language input for this Choreo. 

		@param String - (optional, string) The language in which to return results e.g., es, fr, it, en (the default). See Choreo notes for a link to a full list of supported languages.
		*/
		public void set_Language(String value) {
			this.setInput("Language", value);
		}


		/** 
		Set the value of the Latitude input for this Choreo. 

		@param BigDecimal - (required, decimal) The latitude of the location.
		*/
		public void set_Latitude(BigDecimal value) {
			this.setInput("Latitude", value);
		}

		/** 
		Set the value of the Latitude input for this Choreo as a String. 

		@param String - (required, decimal) The latitude of the location.
		*/
		public void set_Latitude(String value) {
			this.setInput("Latitude", value);	
		}
		/** 
		Set the value of the Longitude input for this Choreo. 

		@param BigDecimal - (required, decimal) The longitude of the location.
		*/
		public void set_Longitude(BigDecimal value) {
			this.setInput("Longitude", value);
		}

		/** 
		Set the value of the Longitude input for this Choreo as a String. 

		@param String - (required, decimal) The longitude of the location.
		*/
		public void set_Longitude(String value) {
			this.setInput("Longitude", value);	
		}
		/** 
		Set the value of the Time input for this Choreo. 

		@param String - (required, date) A UNIX timestamp (seconds since midnight GMT on 1 Jan 1970) or a string formatted date e.g., 2016-03-05T15:48:56Z.
		*/
		public void set_Time(String value) {
			this.setInput("Time", value);
		}


		/** 
		Set the value of the Units input for this Choreo. 

		@param String - (optional, string) Return weather conditions in the requested units. Valid values are: auto, ca, uk2, us (use for Farenheit), and si (use for Celsius).
		*/
		public void set_Units(String value) {
			this.setInput("Units", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the TimeMachineRequest Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class TimeMachineRequestResultSet extends ResultSet {
		public TimeMachineRequestResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "HourlySummary" output from this Choreo execution

		@return String - (string) The hourly summary.
		*/
		public String get_HourlySummary() {
			return this.getResultString("HourlySummary");
		}
		/** 
		Retrieve the value for the "Humidity" output from this Choreo execution

		@return String - (decimal) The current humidity.
		*/
		public String get_Humidity() {
			return this.getResultString("Humidity");
		}
		/** 
		Retrieve the value for the "Pressure" output from this Choreo execution

		@return String - (decimal) The current pressure.
		*/
		public String get_Pressure() {
			return this.getResultString("Pressure");
		}
		/** 
		Retrieve the value for the "Summary" output from this Choreo execution

		@return String - (string) The current weather summary.
		*/
		public String get_Summary() {
			return this.getResultString("Summary");
		}
		/** 
		Retrieve the value for the "Temperature" output from this Choreo execution

		@return String - (decimal) The current temperature.
		*/
		public String get_Temperature() {
			return this.getResultString("Temperature");
		}
		/** 
		Retrieve the value for the "UVIndex" output from this Choreo execution

		@return String - (integer) The current uv index.
		*/
		public String get_UVIndex() {
			return this.getResultString("UVIndex");
		}
		/** 
		Retrieve the value for the "Visibility" output from this Choreo execution

		@return String - (decimal) The current visibility.
		*/
		public String get_Visibility() {
			return this.getResultString("Visibility");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Dark Sky.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
