package com.temboo.Library.Dwolla.Contacts;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
UserContacts

Retrieves the information for contacts for the user assoicated with the authorized access token.
*/
public class UserContacts extends Choreography {

	/**
	Create a new instance of the UserContacts Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public UserContacts(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Dwolla/Contacts/UserContacts"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return UserContactsInputSet
	*/
	public UserContactsInputSet newInputSet() {
		return new UserContactsInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public UserContactsResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new UserContactsResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the UserContacts
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class UserContactsInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) A valid OAuth token.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the Limit input for this Choreo. 

		@param Integer - (optional, integer) Number of contacts to retrieve. Defaults to 10. Can be between 1 and 200 contacts.
		*/
		public void set_Limit(Integer value) {
			this.setInput("Limit", value);
		}

		/** 
		Set the value of the Limit input for this Choreo as a String. 

		@param String - (optional, integer) Number of contacts to retrieve. Defaults to 10. Can be between 1 and 200 contacts.
		*/
		public void set_Limit(String value) {
			this.setInput("Limit", value);	
		}
		/** 
		Set the value of the Search input for this Choreo. 

		@param String - (optional, string) Search term used to search the contacts.
		*/
		public void set_Search(String value) {
			this.setInput("Search", value);
		}


		/** 
		Set the value of the Types input for this Choreo. 

		@param String - (optional, string) Type of accounts to retrieve, in the form of a comma-separated list (e.g. "Facebook,Dwolla")
		*/
		public void set_Types(String value) {
			this.setInput("Types", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the UserContacts Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class UserContactsResultSet extends ResultSet {
		public UserContactsResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Dwolla.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
