package com.temboo.Library.Facebook.Reading;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
TaggableFriends

Returns a list of friends that can be tagged or mentioned in stories published to Facebook.
*/
public class TaggableFriends extends Choreography {

	/**
	Create a new instance of the TaggableFriends Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public TaggableFriends(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Facebook/Reading/TaggableFriends"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return TaggableFriendsInputSet
	*/
	public TaggableFriendsInputSet newInputSet() {
		return new TaggableFriendsInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public TaggableFriendsResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new TaggableFriendsResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the TaggableFriends
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class TaggableFriendsInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) The access token retrieved from the final step of the OAuth process.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the After input for this Choreo. 

		@param String - (optional, string) A cursor that points to the end of the page of data that has been returned. You can pass this cursor to retrievet he next page of results.
		*/
		public void set_After(String value) {
			this.setInput("After", value);
		}


		/** 
		Set the value of the Before input for this Choreo. 

		@param String - (optional, string) A cursor that points to the start of the page of data that has been returned. You can pass this cursor to retrieve the previous page of results.
		*/
		public void set_Before(String value) {
			this.setInput("Before", value);
		}


		/** 
		Set the value of the Fields input for this Choreo. 

		@param String - (optional, string) A comma separated list of fields to return (i.e. id,name).
		*/
		public void set_Fields(String value) {
			this.setInput("Fields", value);
		}


		/** 
		Set the value of the Limit input for this Choreo. 

		@param Integer - (optional, integer) Limits the number of records returned in the response.
		*/
		public void set_Limit(Integer value) {
			this.setInput("Limit", value);
		}

		/** 
		Set the value of the Limit input for this Choreo as a String. 

		@param String - (optional, integer) Limits the number of records returned in the response.
		*/
		public void set_Limit(String value) {
			this.setInput("Limit", value);	
		}
		/** 
		Set the value of the ProfileID input for this Choreo. 

		@param String - (optional, string) The id of the profile to retrieve tagged places for. Defaults to "me" indicating the authenticated user.
		*/
		public void set_ProfileID(String value) {
			this.setInput("ProfileID", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the TaggableFriends Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class TaggableFriendsResultSet extends ResultSet {
		public TaggableFriendsResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "HasNext" output from this Choreo execution

		@return String - (boolean) A boolean flag indicating that a next page exists.
		*/
		public String get_HasNext() {
			return this.getResultString("HasNext");
		}
		/** 
		Retrieve the value for the "HasPrevious" output from this Choreo execution

		@return String - (boolean) A boolean flag indicating that a previous page exists.
		*/
		public String get_HasPrevious() {
			return this.getResultString("HasPrevious");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Facebook. Corresponds to the ResponseFormat input. Defaults to JSON.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
