package com.temboo.Library.Facebook.Actions.Music.Listens;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
UpdateListen

Updates and existing listen action.
*/
public class UpdateListen extends Choreography {

	/**
	Create a new instance of the UpdateListen Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public UpdateListen(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Facebook/Actions/Music/Listens/UpdateListen"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return UpdateListenInputSet
	*/
	public UpdateListenInputSet newInputSet() {
		return new UpdateListenInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public UpdateListenResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new UpdateListenResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the UpdateListen
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class UpdateListenInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) The access token retrieved from the final step of the OAuth process.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the ActionID input for this Choreo. 

		@param String - (required, string) The id of the action to update.
		*/
		public void set_ActionID(String value) {
			this.setInput("ActionID", value);
		}


		/** 
		Set the value of the Album input for this Choreo. 

		@param String - (optional, string) The URL or ID for an Open Graph object representing  representing an album.
		*/
		public void set_Album(String value) {
			this.setInput("Album", value);
		}


		/** 
		Set the value of the EndTime input for this Choreo. 

		@param String - (optional, date) The time that the user ended the action (e.g. 2013-06-24T18:53:35+0000).
		*/
		public void set_EndTime(String value) {
			this.setInput("EndTime", value);
		}


		/** 
		Set the value of the ExpiresIn input for this Choreo. 

		@param Integer - (optional, integer) The amount of time (in milliseconds) from the publish_time that the action will expire.
		*/
		public void set_ExpiresIn(Integer value) {
			this.setInput("ExpiresIn", value);
		}

		/** 
		Set the value of the ExpiresIn input for this Choreo as a String. 

		@param String - (optional, integer) The amount of time (in milliseconds) from the publish_time that the action will expire.
		*/
		public void set_ExpiresIn(String value) {
			this.setInput("ExpiresIn", value);	
		}
		/** 
		Set the value of the Message input for this Choreo. 

		@param String - (optional, string) A message attached to this fitness action. Setting this parameter requires enabling of message capabilities.
		*/
		public void set_Message(String value) {
			this.setInput("Message", value);
		}


		/** 
		Set the value of the Musician input for this Choreo. 

		@param String - (optional, string) The URL or ID for an Open Graph object representing representing a musician.
		*/
		public void set_Musician(String value) {
			this.setInput("Musician", value);
		}


		/** 
		Set the value of the Paused input for this Choreo. 

		@param Boolean - (optional, boolean) Whether the audio is paused or not
		*/
		public void set_Paused(Boolean value) {
			this.setInput("Paused", value);
		}

		/** 
		Set the value of the Paused input for this Choreo as a String. 

		@param String - (optional, boolean) Whether the audio is paused or not
		*/
		public void set_Paused(String value) {
			this.setInput("Paused", value);	
		}
		/** 
		Set the value of the Place input for this Choreo. 

		@param String - (optional, string) The URL or ID for an Open Graph object representing the location associated with this action.
		*/
		public void set_Place(String value) {
			this.setInput("Place", value);
		}


		/** 
		Set the value of the Playlist input for this Choreo. 

		@param String - (optional, string) The URL or ID for an Open Graph object representing representing a playlist.
		*/
		public void set_Playlist(String value) {
			this.setInput("Playlist", value);
		}


		/** 
		Set the value of the RadioStation input for this Choreo. 

		@param String - (optional, string) The URL or ID for an Open Graph object representing  representing a radio station.
		*/
		public void set_RadioStation(String value) {
			this.setInput("RadioStation", value);
		}


		/** 
		Set the value of the Song input for this Choreo. 

		@param String - (optional, string) The URL or ID for an Open Graph object representing  representing a song.
		*/
		public void set_Song(String value) {
			this.setInput("Song", value);
		}


		/** 
		Set the value of the Tags input for this Choreo. 

		@param String - (optional, string) A comma separated list of other profile IDs that also performed this action.
		*/
		public void set_Tags(String value) {
			this.setInput("Tags", value);
		}


		/** 
		Set the value of the ViaUser input for this Choreo. 

		@param Integer - (optional, integer) The ID of anyone whom the user discovered this audio from
		*/
		public void set_ViaUser(Integer value) {
			this.setInput("ViaUser", value);
		}

		/** 
		Set the value of the ViaUser input for this Choreo as a String. 

		@param String - (optional, integer) The ID of anyone whom the user discovered this audio from
		*/
		public void set_ViaUser(String value) {
			this.setInput("ViaUser", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the UpdateListen Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class UpdateListenResultSet extends ResultSet {
		public UpdateListenResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Facebook. Corresponds to the ResponseFormat input. Defaults to JSON.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
