package com.temboo.Library.DonorsChoose;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
MathAndScience

Returns results for projects within the Math and Science category.
*/
public class MathAndScience extends Choreography {

	/**
	Create a new instance of the MathAndScience Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public MathAndScience(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/DonorsChoose/MathAndScience"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return MathAndScienceInputSet
	*/
	public MathAndScienceInputSet newInputSet() {
		return new MathAndScienceInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public MathAndScienceResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new MathAndScienceResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the MathAndScience
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class MathAndScienceInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (optional, string) The APIKey provided by DonorsChoose.org. Defaults to the test  APIKey 'DONORSCHOOSE'.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the Index input for this Choreo. 

		@param Integer - (optional, integer) The number of the first row to return in the result. For example, if index=10, the results could show rows 10-59.
		*/
		public void set_Index(Integer value) {
			this.setInput("Index", value);
		}

		/** 
		Set the value of the Index input for this Choreo as a String. 

		@param String - (optional, integer) The number of the first row to return in the result. For example, if index=10, the results could show rows 10-59.
		*/
		public void set_Index(String value) {
			this.setInput("Index", value);	
		}
		/** 
		Set the value of the Max input for this Choreo. 

		@param Integer - (optional, integer) The max number of projects to return. Can return up to 50 rows at a time. Defaults to 10 when left empty.
		*/
		public void set_Max(Integer value) {
			this.setInput("Max", value);
		}

		/** 
		Set the value of the Max input for this Choreo as a String. 

		@param String - (optional, integer) The max number of projects to return. Can return up to 50 rows at a time. Defaults to 10 when left empty.
		*/
		public void set_Max(String value) {
			this.setInput("Max", value);	
		}
		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Can be set to xml or json. Defaults to xml.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the ShowSynopsis input for this Choreo. 

		@param Boolean - (optional, boolean) Set to 1 to show the synopsis for each project listing
		*/
		public void set_ShowSynopsis(Boolean value) {
			this.setInput("ShowSynopsis", value);
		}

		/** 
		Set the value of the ShowSynopsis input for this Choreo as a String. 

		@param String - (optional, boolean) Set to 1 to show the synopsis for each project listing
		*/
		public void set_ShowSynopsis(String value) {
			this.setInput("ShowSynopsis", value);	
		}
		/** 
		Set the value of the Subject input for this Choreo. 

		@param String - (optional, string) Enter a sub-category of Math & Science. When left empty, all Math & Science projects are returned.
		*/
		public void set_Subject(String value) {
			this.setInput("Subject", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the MathAndScience Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class MathAndScienceResultSet extends ResultSet {
		public MathAndScienceResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from DonorsChoose.org
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
