package com.temboo.Library.Box.Files;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
UploadFile

Uploads a new file to a user's account. This can also be used when updating the contents of an existing file.
*/
public class UploadFile extends Choreography {

	/**
	Create a new instance of the UploadFile Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public UploadFile(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Box/Files/UploadFile"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return UploadFileInputSet
	*/
	public UploadFileInputSet newInputSet() {
		return new UploadFileInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public UploadFileResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new UploadFileResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the UploadFile
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class UploadFileInputSet extends InputSet {
		/** 
		Set the value of the FileContents input for this Choreo. 

		@param String - (conditional, string) The Base64 encoded contents of the file you want to upload.
		*/
		public void set_FileContents(String value) {
			this.setInput("FileContents", value);
		}


		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) The access token retrieved during the OAuth2 process.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the AsUser input for this Choreo. 

		@param String - (optional, string) The ID of the user. Only used for enterprise administrators to make API calls for their managed users.
		*/
		public void set_AsUser(String value) {
			this.setInput("AsUser", value);
		}


		/** 
		Set the value of the FileID input for this Choreo. 

		@param String - (optional, string) When providing the id of an existing file, the content of the file will be updated.
		*/
		public void set_FileID(String value) {
			this.setInput("FileID", value);
		}


		/** 
		Set the value of the FileName input for this Choreo. 

		@param String - (conditional, string) The name of the new file to upload. Note that when providing the FileID in order to perform an update to a file, it is not necessary to provide the FileName.
		*/
		public void set_FileName(String value) {
			this.setInput("FileName", value);
		}


		/** 
		Set the value of the FolderID input for this Choreo. 

		@param String - (optional, string) The ID of the target folder to upload the file to. Defaults to 0 indicating the root folder.
		*/
		public void set_FolderID(String value) {
			this.setInput("FolderID", value);
		}


		/** 
		Set the value of the VaultFile input for this Choreo. 

		@param TembooPath - (optional, vault file) The path to a vault file that you want to upload. Required unless using the FileContents input.
		*/

	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the UploadFile Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class UploadFileResultSet extends ResultSet {
		public UploadFileResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Box.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
