package com.temboo.Library.ConstantContact;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
UpdateContact

Updates an existing contact in your Constant Contact system when you supply a contact ID to the Choreo.
*/
public class UpdateContact extends Choreography {

	/**
	Create a new instance of the UpdateContact Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public UpdateContact(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/ConstantContact/UpdateContact"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return UpdateContactInputSet
	*/
	public UpdateContactInputSet newInputSet() {
		return new UpdateContactInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public UpdateContactResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new UpdateContactResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the UpdateContact
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class UpdateContactInputSet extends InputSet {
		/** 
		Set the value of the UpdatedContactXML input for this Choreo. 

		@param String - (required, xml) This input should be the updated XML returned from the ObtainContactInformation Choreo.
		*/
		public void set_UpdatedContactXML(String value) {
			this.setInput("UpdatedContactXML", value);
		}


		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key provided by Constant Contact.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the ContactId input for this Choreo. 

		@param Integer - (required, integer) The id for the contact you want to update.
		*/
		public void set_ContactId(Integer value) {
			this.setInput("ContactId", value);
		}

		/** 
		Set the value of the ContactId input for this Choreo as a String. 

		@param String - (required, integer) The id for the contact you want to update.
		*/
		public void set_ContactId(String value) {
			this.setInput("ContactId", value);	
		}
		/** 
		Set the value of the ListId input for this Choreo. 

		@param Integer - (required, integer) The ID for the list that you want to update
		*/
		public void set_ListId(Integer value) {
			this.setInput("ListId", value);
		}

		/** 
		Set the value of the ListId input for this Choreo as a String. 

		@param String - (required, integer) The ID for the list that you want to update
		*/
		public void set_ListId(String value) {
			this.setInput("ListId", value);	
		}
		/** 
		Set the value of the Password input for this Choreo. 

		@param String - (required, password) Your Constant Contact password.
		*/
		public void set_Password(String value) {
			this.setInput("Password", value);
		}


		/** 
		Set the value of the UserName input for this Choreo. 

		@param String - (required, string) You Constant Contact username.
		*/
		public void set_UserName(String value) {
			this.setInput("UserName", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the UpdateContact Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class UpdateContactResultSet extends ResultSet {
		public UpdateContactResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (xml) The response from Constant Contact. Note that a successful update returns no content.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
