package com.temboo.Library.MailChimp;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
ListSubscribe

Adds a subscriber to a MailChimp list.
*/
public class ListSubscribe extends Choreography {

	/**
	Create a new instance of the ListSubscribe Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public ListSubscribe(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/MailChimp/ListSubscribe"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ListSubscribeInputSet
	*/
	public ListSubscribeInputSet newInputSet() {
		return new ListSubscribeInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ListSubscribeResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ListSubscribeResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the ListSubscribe
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ListSubscribeInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key provided by Mailchimp.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the DoubleOptIn input for this Choreo. 

		@param Boolean - (optional, boolean) Flag to control whether a double opt-in confirmation message is sent. Specify '1' (true) or '0' (false). Defaults to 0.
		*/
		public void set_DoubleOptIn(Boolean value) {
			this.setInput("DoubleOptIn", value);
		}

		/** 
		Set the value of the DoubleOptIn input for this Choreo as a String. 

		@param String - (optional, boolean) Flag to control whether a double opt-in confirmation message is sent. Specify '1' (true) or '0' (false). Defaults to 0.
		*/
		public void set_DoubleOptIn(String value) {
			this.setInput("DoubleOptIn", value);	
		}
		/** 
		Set the value of the EmailAddress input for this Choreo. 

		@param String - (conditional, string) The email address for the subscriber you want to create. Required unless the email address is included in the MergeVars input as part of your JSON object.
		*/
		public void set_EmailAddress(String value) {
			this.setInput("EmailAddress", value);
		}


		/** 
		Set the value of the EmailType input for this Choreo. 

		@param String - (optional, string) Must be one of 'text', 'html', or 'mobile'. Defaults to html.
		*/
		public void set_EmailType(String value) {
			this.setInput("EmailType", value);
		}


		/** 
		Set the value of the ListId input for this Choreo. 

		@param String - (required, string) The id of the list that the subsbriber will be added to.
		*/
		public void set_ListId(String value) {
			this.setInput("ListId", value);
		}


		/** 
		Set the value of the MergeVars input for this Choreo. 

		@param String - (conditional, json) A JSON object of the merge fields for this subscriber. If the subscriber email address is not provided for the EmailAddress input, it must be specified here.
		*/
		public void set_MergeVars(String value) {
			this.setInput("MergeVars", value);
		}


		/** 
		Set the value of the ReplaceInterests input for this Choreo. 

		@param Boolean - (optional, boolean) A flag to determine whether to replace the interest groups with the groups provided or add the provided groups to the member's interest groups. Specify '1' (true) or '0' (false). Defaults to 1.
		*/
		public void set_ReplaceInterests(Boolean value) {
			this.setInput("ReplaceInterests", value);
		}

		/** 
		Set the value of the ReplaceInterests input for this Choreo as a String. 

		@param String - (optional, boolean) A flag to determine whether to replace the interest groups with the groups provided or add the provided groups to the member's interest groups. Specify '1' (true) or '0' (false). Defaults to 1.
		*/
		public void set_ReplaceInterests(String value) {
			this.setInput("ReplaceInterests", value);	
		}
		/** 
		Set the value of the SendWelcome input for this Choreo. 

		@param Boolean - (optional, boolean) If double_optin is false and this flag is true, a welcome email will be sent. Note that this does not apply when updating records. Specify '1' (true) or '0' (false). Defaults to 0.
		*/
		public void set_SendWelcome(Boolean value) {
			this.setInput("SendWelcome", value);
		}

		/** 
		Set the value of the SendWelcome input for this Choreo as a String. 

		@param String - (optional, boolean) If double_optin is false and this flag is true, a welcome email will be sent. Note that this does not apply when updating records. Specify '1' (true) or '0' (false). Defaults to 0.
		*/
		public void set_SendWelcome(String value) {
			this.setInput("SendWelcome", value);	
		}
		/** 
		Set the value of the UpdateExisting input for this Choreo. 

		@param Boolean - (optional, boolean) Indicates that if the email already exists, this request will perform an update instead of an insert. Specify '1' (true) or '0' (false). Defaults to 1.
		*/
		public void set_UpdateExisting(Boolean value) {
			this.setInput("UpdateExisting", value);
		}

		/** 
		Set the value of the UpdateExisting input for this Choreo as a String. 

		@param String - (optional, boolean) Indicates that if the email already exists, this request will perform an update instead of an insert. Specify '1' (true) or '0' (false). Defaults to 1.
		*/
		public void set_UpdateExisting(String value) {
			this.setInput("UpdateExisting", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the ListSubscribe Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ListSubscribeResultSet extends ResultSet {
		public ListSubscribeResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Mailchimp. Returns the string "true" for success and an error description for failures.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
