package com.temboo.Library.MailChimp;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
ListMergeVarAdd

Add a new field to a MailChimp list.
*/
public class ListMergeVarAdd extends Choreography {

	/**
	Create a new instance of the ListMergeVarAdd Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public ListMergeVarAdd(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/MailChimp/ListMergeVarAdd"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ListMergeVarAddInputSet
	*/
	public ListMergeVarAddInputSet newInputSet() {
		return new ListMergeVarAddInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ListMergeVarAddResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ListMergeVarAddResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the ListMergeVarAdd
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ListMergeVarAddInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key provided by Mailchimp.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the Choices input for this Choreo. 

		@param String - (optional, string) A list of up to 10 choices for radio and dropdown type fields )separated by commas).
		*/
		public void set_Choices(String value) {
			this.setInput("Choices", value);
		}


		/** 
		Set the value of the DateFormat input for this Choreo. 

		@param String - (optional, string) Valid for birthday and date fields. For birthday, must be "MM/DD" (default) or "DD/MM". For date type, must be "MM/DD/YYYY" (default) or "DD/MM/YYYY".
		*/
		public void set_DateFormat(String value) {
			this.setInput("DateFormat", value);
		}


		/** 
		Set the value of the DefaultCountry input for this Choreo. 

		@param String - (optional, string) The ISO 3166 2 digit character code for the default country. Defaults to "US".
		*/
		public void set_DefaultCountry(String value) {
			this.setInput("DefaultCountry", value);
		}


		/** 
		Set the value of the DefaultValue input for this Choreo. 

		@param String - (optional, string) The default value for the new field.
		*/
		public void set_DefaultValue(String value) {
			this.setInput("DefaultValue", value);
		}


		/** 
		Set the value of the FieldType input for this Choreo. 

		@param String - (optional, string) Must be either left unset or one of 'text', 'number', 'radio', 'dropdown', 'date', 'address', 'phone', 'url', or 'imageurl. Defaults to text.
		*/
		public void set_FieldType(String value) {
			this.setInput("FieldType", value);
		}


		/** 
		Set the value of the ListId input for this Choreo. 

		@param String - (required, string) The ID of the list on which to add the new merge var.
		*/
		public void set_ListId(String value) {
			this.setInput("ListId", value);
		}


		/** 
		Set the value of the Name input for this Choreo. 

		@param String - (required, string) Provide a long merge var name for user display (i.e. First Name)
		*/
		public void set_Name(String value) {
			this.setInput("Name", value);
		}


		/** 
		Set the value of the PhoneFormat input for this Choreo. 

		@param String - (optional, string) Defaults to "US"  - any other value will cause them to be unformatted (international).
		*/
		public void set_PhoneFormat(String value) {
			this.setInput("PhoneFormat", value);
		}


		/** 
		Set the value of the Public input for this Choreo. 

		@param Boolean - (optional, boolean) Indicates whether the field is displayed in public. Specify '1' (true) or '0' (false). Defaults to 1.
		*/
		public void set_Public(Boolean value) {
			this.setInput("Public", value);
		}

		/** 
		Set the value of the Public input for this Choreo as a String. 

		@param String - (optional, boolean) Indicates whether the field is displayed in public. Specify '1' (true) or '0' (false). Defaults to 1.
		*/
		public void set_Public(String value) {
			this.setInput("Public", value);	
		}
		/** 
		Set the value of the Req input for this Choreo. 

		@param Boolean - (optional, boolean) Indicates that the field will be required.  Specify '1' (true) or '0' (false). Defaults to 0.
		*/
		public void set_Req(Boolean value) {
			this.setInput("Req", value);
		}

		/** 
		Set the value of the Req input for this Choreo as a String. 

		@param String - (optional, boolean) Indicates that the field will be required.  Specify '1' (true) or '0' (false). Defaults to 0.
		*/
		public void set_Req(String value) {
			this.setInput("Req", value);	
		}
		/** 
		Set the value of the Show input for this Choreo. 

		@param Boolean - (optional, boolean) Indicates whether the field is displayed in the app's list member view.  Specify '1' (true) or '0' (false). Defaults to 1.
		*/
		public void set_Show(Boolean value) {
			this.setInput("Show", value);
		}

		/** 
		Set the value of the Show input for this Choreo as a String. 

		@param String - (optional, boolean) Indicates whether the field is displayed in the app's list member view.  Specify '1' (true) or '0' (false). Defaults to 1.
		*/
		public void set_Show(String value) {
			this.setInput("Show", value);	
		}
		/** 
		Set the value of the Tag input for this Choreo. 

		@param String - (required, string) Provide a short merge var tag name. MUST be 10 UTF-8 chars, including 'A-Z', '0-9', or '_' only (i.e. DESC123456).
		*/
		public void set_Tag(String value) {
			this.setInput("Tag", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the ListMergeVarAdd Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ListMergeVarAddResultSet extends ResultSet {
		public ListMergeVarAddResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (boolean) The response from Mailchimp. Returns the string "true" for success and an error description for failures.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
