package com.temboo.Library.Amazon.SQS;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
ReceiveMessage

Returns one or more messages from the specified queue.
*/
public class ReceiveMessage extends Choreography {

	/**
	Create a new instance of the ReceiveMessage Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public ReceiveMessage(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Amazon/SQS/ReceiveMessage"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ReceiveMessageInputSet
	*/
	public ReceiveMessageInputSet newInputSet() {
		return new ReceiveMessageInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ReceiveMessageResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ReceiveMessageResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the ReceiveMessage
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ReceiveMessageInputSet extends InputSet {
		/** 
		Set the value of the AWSAccessKeyId input for this Choreo. 

		@param String - (required, string) The Access Key ID provided by Amazon Web Services.
		*/
		public void set_AWSAccessKeyId(String value) {
			this.setInput("AWSAccessKeyId", value);
		}


		/** 
		Set the value of the AWSAccountId input for this Choreo. 

		@param Integer - (required, integer) The id for the AWS account associated with the queue you're retrieving a message from (remove all dashes in the account number).
		*/
		public void set_AWSAccountId(Integer value) {
			this.setInput("AWSAccountId", value);
		}

		/** 
		Set the value of the AWSAccountId input for this Choreo as a String. 

		@param String - (required, integer) The id for the AWS account associated with the queue you're retrieving a message from (remove all dashes in the account number).
		*/
		public void set_AWSAccountId(String value) {
			this.setInput("AWSAccountId", value);	
		}
		/** 
		Set the value of the AWSSecretKeyId input for this Choreo. 

		@param String - (required, string) The Secret Key ID provided by Amazon Web Services.
		*/
		public void set_AWSSecretKeyId(String value) {
			this.setInput("AWSSecretKeyId", value);
		}


		/** 
		Set the value of the AttributeName input for this Choreo. 

		@param String - (optional, string) The attribute you wish to return. Values are: All (default), SenderId, SentTimestamp, ApproximateReceiveCount, or ApproximateFirstReceiveTimestamp.
		*/
		public void set_AttributeName(String value) {
			this.setInput("AttributeName", value);
		}


		/** 
		Set the value of the MaxNumberOfMessages input for this Choreo. 

		@param Integer - (optional, integer) The maximum number of messages to return. Defaults to 1.
		*/
		public void set_MaxNumberOfMessages(Integer value) {
			this.setInput("MaxNumberOfMessages", value);
		}

		/** 
		Set the value of the MaxNumberOfMessages input for this Choreo as a String. 

		@param String - (optional, integer) The maximum number of messages to return. Defaults to 1.
		*/
		public void set_MaxNumberOfMessages(String value) {
			this.setInput("MaxNumberOfMessages", value);	
		}
		/** 
		Set the value of the MessageAttributeName input for this Choreo. 

		@param String - (optional, string) The name of a message attribute to return. You can return all of the attributes by specifying "All".
		*/
		public void set_MessageAttributeName(String value) {
			this.setInput("MessageAttributeName", value);
		}


		/** 
		Set the value of the QueueName input for this Choreo. 

		@param String - (required, string) The name of the queue you want to retrieve a message from.
		*/
		public void set_QueueName(String value) {
			this.setInput("QueueName", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the UserRegion input for this Choreo. 

		@param String - (optional, string) The AWS region that corresponds to the SQS endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
		*/
		public void set_UserRegion(String value) {
			this.setInput("UserRegion", value);
		}


		/** 
		Set the value of the VisibilityTimeout input for this Choreo. 

		@param Integer - (optional, integer) The duration (in seconds) that the received messages are hidden from future retrieve requests after a ReceiveMessage request (max is 43200).
		*/
		public void set_VisibilityTimeout(Integer value) {
			this.setInput("VisibilityTimeout", value);
		}

		/** 
		Set the value of the VisibilityTimeout input for this Choreo as a String. 

		@param String - (optional, integer) The duration (in seconds) that the received messages are hidden from future retrieve requests after a ReceiveMessage request (max is 43200).
		*/
		public void set_VisibilityTimeout(String value) {
			this.setInput("VisibilityTimeout", value);	
		}
		/** 
		Set the value of the WaitTimeSeconds input for this Choreo. 

		@param Integer - (optional, integer) The duration (in seconds) for which the call will wait for a message to arrive in the queue before returning. If a message is available, the call will return sooner than WaitTimeSeconds.
		*/
		public void set_WaitTimeSeconds(Integer value) {
			this.setInput("WaitTimeSeconds", value);
		}

		/** 
		Set the value of the WaitTimeSeconds input for this Choreo as a String. 

		@param String - (optional, integer) The duration (in seconds) for which the call will wait for a message to arrive in the queue before returning. If a message is available, the call will return sooner than WaitTimeSeconds.
		*/
		public void set_WaitTimeSeconds(String value) {
			this.setInput("WaitTimeSeconds", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the ReceiveMessage Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ReceiveMessageResultSet extends ResultSet {
		public ReceiveMessageResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Body" output from this Choreo execution

		@return String - (string) The body of the latest message.
		*/
		public String get_Body() {
			return this.getResultString("Body");
		}
		/** 
		Retrieve the value for the "MessageId" output from this Choreo execution

		@return String - (string) A unique identifier for the latest message.
		*/
		public String get_MessageId() {
			return this.getResultString("MessageId");
		}
		/** 
		Retrieve the value for the "ReceiptHandle" output from this Choreo execution

		@return String - (string) An identifier associated with the act of receiving the message. A new receipt handle is returned every time you receive a message. Provide the last received receipt handle to delete the message.
		*/
		public String get_ReceiptHandle() {
			return this.getResultString("ReceiptHandle");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Amazon.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
