package com.temboo.Library.Amazon.Marketplace.Feeds;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetFeedSubmissionList

Returns a list of all feed submissions submitted in the previous 90 days.
*/
public class GetFeedSubmissionList extends Choreography {

	/**
	Create a new instance of the GetFeedSubmissionList Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetFeedSubmissionList(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Amazon/Marketplace/Feeds/GetFeedSubmissionList"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetFeedSubmissionListInputSet
	*/
	public GetFeedSubmissionListInputSet newInputSet() {
		return new GetFeedSubmissionListInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetFeedSubmissionListResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetFeedSubmissionListResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetFeedSubmissionList
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetFeedSubmissionListInputSet extends InputSet {
		/** 
		Set the value of the AWSAccessKeyId input for this Choreo. 

		@param String - (required, string) The Access Key ID provided by Amazon Web Services.
		*/
		public void set_AWSAccessKeyId(String value) {
			this.setInput("AWSAccessKeyId", value);
		}


		/** 
		Set the value of the AWSMarketplaceId input for this Choreo. 

		@param String - (required, string) The Marketplace ID provided by Amazon Web Services.
		*/
		public void set_AWSMarketplaceId(String value) {
			this.setInput("AWSMarketplaceId", value);
		}


		/** 
		Set the value of the AWSMerchantId input for this Choreo. 

		@param String - (required, string) The Merchant ID provided by Amazon Web Services.
		*/
		public void set_AWSMerchantId(String value) {
			this.setInput("AWSMerchantId", value);
		}


		/** 
		Set the value of the AWSSecretKeyId input for this Choreo. 

		@param String - (required, string) The Secret Key ID provided by Amazon Web Services.
		*/
		public void set_AWSSecretKeyId(String value) {
			this.setInput("AWSSecretKeyId", value);
		}


		/** 
		Set the value of the Endpoint input for this Choreo. 

		@param String - (conditional, string) The base URL for the MWS endpoint. Defaults to mws.amazonservices.co.uk.
		*/
		public void set_Endpoint(String value) {
			this.setInput("Endpoint", value);
		}


		/** 
		Set the value of the FeedProcessingStatusList input for this Choreo. 

		@param String - (optional, string) A comma separated list of one or more feed processing statuses by which to filter the list of feed submissions.
		*/
		public void set_FeedProcessingStatusList(String value) {
			this.setInput("FeedProcessingStatusList", value);
		}


		/** 
		Set the value of the FeedSubmissionIdList input for this Choreo. 

		@param String - (optional, string) A comma separated list of FeedSubmmissionId values. If you pass in FeedSubmmissionId values in a request, other query conditions are ignored.
		*/
		public void set_FeedSubmissionIdList(String value) {
			this.setInput("FeedSubmissionIdList", value);
		}


		/** 
		Set the value of the FeedTypeList input for this Choreo. 

		@param String - (optional, string) A comma separated list of one or more FeedType enumeration values by which to filter the list of feed submissions.
		*/
		public void set_FeedTypeList(String value) {
			this.setInput("FeedTypeList", value);
		}


		/** 
		Set the value of the MWSAuthToken input for this Choreo. 

		@param String - (optional, string) The Amazon MWS authorization token for the given seller and developer.
		*/
		public void set_MWSAuthToken(String value) {
			this.setInput("MWSAuthToken", value);
		}


		/** 
		Set the value of the MaxCount input for this Choreo. 

		@param Integer - (optional, integer) A non-negative integer that indicates the maximum number of feed submissions to return in the list. Defaults to 10. Max is 100.
		*/
		public void set_MaxCount(Integer value) {
			this.setInput("MaxCount", value);
		}

		/** 
		Set the value of the MaxCount input for this Choreo as a String. 

		@param String - (optional, integer) A non-negative integer that indicates the maximum number of feed submissions to return in the list. Defaults to 10. Max is 100.
		*/
		public void set_MaxCount(String value) {
			this.setInput("MaxCount", value);	
		}
		/** 
		Set the value of the SubmittedFromDate input for this Choreo. 

		@param String - (optional, date) The earliest submission date that you are looking for, in ISO8601 date format (i.e. 2012-01-01).
		*/
		public void set_SubmittedFromDate(String value) {
			this.setInput("SubmittedFromDate", value);
		}


		/** 
		Set the value of the SubmittedToDate input for this Choreo. 

		@param String - (optional, date) The latest submission date that you are looking for, in ISO8601 date format (i.e. 2012-01-01).
		*/
		public void set_SubmittedToDate(String value) {
			this.setInput("SubmittedToDate", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetFeedSubmissionList Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetFeedSubmissionListResultSet extends ResultSet {
		public GetFeedSubmissionListResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "FeedProcessingStatus" output from this Choreo execution

		@return String - (string) The FeedProcessingStatus parsed from the Amazon response.
		*/
		public String get_FeedProcessingStatus() {
			return this.getResultString("FeedProcessingStatus");
		}
		/** 
		Retrieve the value for the "FeedSubmissionId" output from this Choreo execution

		@return String - (integer) The FeedSubmissionId parsed from the Amazon response. If multiple records are returned, this output variable will contain the first id in the list.
		*/
		public String get_FeedSubmissionId() {
			return this.getResultString("FeedSubmissionId");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (xml) Stores the response from Amazon.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
