package com.temboo.Library.Amazon.MachineLearning;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
DescribeEvaluations

Returns a list of Evaluations that match the search criteria in the request.
*/
public class DescribeEvaluations extends Choreography {

	/**
	Create a new instance of the DescribeEvaluations Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public DescribeEvaluations(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Amazon/MachineLearning/DescribeEvaluations"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return DescribeEvaluationsInputSet
	*/
	public DescribeEvaluationsInputSet newInputSet() {
		return new DescribeEvaluationsInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public DescribeEvaluationsResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new DescribeEvaluationsResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the DescribeEvaluations
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class DescribeEvaluationsInputSet extends InputSet {
		/** 
		Set the value of the AWSAccessKeyId input for this Choreo. 

		@param String - (required, string) The Access Key ID provided by Amazon Web Services.
		*/
		public void set_AWSAccessKeyId(String value) {
			this.setInput("AWSAccessKeyId", value);
		}


		/** 
		Set the value of the AWSSecretKeyId input for this Choreo. 

		@param String - (required, string) The Secret Key ID provided by Amazon Web Services.
		*/
		public void set_AWSSecretKeyId(String value) {
			this.setInput("AWSSecretKeyId", value);
		}


		/** 
		Set the value of the EQ input for this Choreo. 

		@param String - (optional, string) The equal to operator. The Evaluation results will have FilterVariable values that exactly match the value specified with EQ.
		*/
		public void set_EQ(String value) {
			this.setInput("EQ", value);
		}


		/** 
		Set the value of the FilterVariable input for this Choreo. 

		@param String - (optional, string) Use one of the following variables to filter a list of Evaluation: CreatedAt, Status, Name, IAMUser, MLModelId, DataSourceId, DataUri.
		*/
		public void set_FilterVariable(String value) {
			this.setInput("FilterVariable", value);
		}


		/** 
		Set the value of the GE input for this Choreo. 

		@param String - (optional, string) The greater than or equal to operator. The Evaluation results will have FilterVariable values that are greater than or equal to the value specified with GE.
		*/
		public void set_GE(String value) {
			this.setInput("GE", value);
		}


		/** 
		Set the value of the GT input for this Choreo. 

		@param String - (optional, string) The greater than operator. The Evaluation results will have FilterVariable values that are greater than the value specified with GT.
		*/
		public void set_GT(String value) {
			this.setInput("GT", value);
		}


		/** 
		Set the value of the LE input for this Choreo. 

		@param String - (optional, string) The less than or equal to operator. The Evaluation results will have FilterVariable values that are less than or equal to the value specified with LE.
		*/
		public void set_LE(String value) {
			this.setInput("LE", value);
		}


		/** 
		Set the value of the LT input for this Choreo. 

		@param String - (optional, string) The less than operator. The Evaluation results will have FilterVariable values that are less than the value specified with LT.
		*/
		public void set_LT(String value) {
			this.setInput("LT", value);
		}


		/** 
		Set the value of the Limit input for this Choreo. 

		@param Integer - (optional, integer) The maximum number of Evaluation to include in the result.
		*/
		public void set_Limit(Integer value) {
			this.setInput("Limit", value);
		}

		/** 
		Set the value of the Limit input for this Choreo as a String. 

		@param String - (optional, integer) The maximum number of Evaluation to include in the result.
		*/
		public void set_Limit(String value) {
			this.setInput("Limit", value);	
		}
		/** 
		Set the value of the NE input for this Choreo. 

		@param String - (optional, string) The not equal to operator. The Evaluation results will have FilterVariable values not equal to the value specified with NE.
		*/
		public void set_NE(String value) {
			this.setInput("NE", value);
		}


		/** 
		Set the value of the NextToken input for this Choreo. 

		@param String - (optional, string) The ID of the page in the paginated results.
		*/
		public void set_NextToken(String value) {
			this.setInput("NextToken", value);
		}


		/** 
		Set the value of the Prefix input for this Choreo. 

		@param String - (optional, string) A string that is found at the beginning of a variable, such as Name or Id.
		*/
		public void set_Prefix(String value) {
			this.setInput("Prefix", value);
		}


		/** 
		Set the value of the SortOrder input for this Choreo. 

		@param String - (optional, string) Determines the sequence of the resulting list of Evaluation. Valid values are: asc, dsc.
		*/
		public void set_SortOrder(String value) {
			this.setInput("SortOrder", value);
		}


		/** 
		Set the value of the UserRegion input for this Choreo. 

		@param String - (optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
		*/
		public void set_UserRegion(String value) {
			this.setInput("UserRegion", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the DescribeEvaluations Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class DescribeEvaluationsResultSet extends ResultSet {
		public DescribeEvaluationsResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Amazon.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
