package com.temboo.Library.Amazon.IAM;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
UpdateAccountPasswordPolicy

Updates the password policy settings for the account.
*/
public class UpdateAccountPasswordPolicy extends Choreography {

	/**
	Create a new instance of the UpdateAccountPasswordPolicy Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public UpdateAccountPasswordPolicy(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Amazon/IAM/UpdateAccountPasswordPolicy"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return UpdateAccountPasswordPolicyInputSet
	*/
	public UpdateAccountPasswordPolicyInputSet newInputSet() {
		return new UpdateAccountPasswordPolicyInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public UpdateAccountPasswordPolicyResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new UpdateAccountPasswordPolicyResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the UpdateAccountPasswordPolicy
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class UpdateAccountPasswordPolicyInputSet extends InputSet {
		/** 
		Set the value of the AWSAccessKeyId input for this Choreo. 

		@param String - (required, string) The Access Key ID provided by Amazon Web Services.
		*/
		public void set_AWSAccessKeyId(String value) {
			this.setInput("AWSAccessKeyId", value);
		}


		/** 
		Set the value of the AWSSecretKeyId input for this Choreo. 

		@param String - (required, string) The Secret Key ID provided by Amazon Web Services.
		*/
		public void set_AWSSecretKeyId(String value) {
			this.setInput("AWSSecretKeyId", value);
		}


		/** 
		Set the value of the AllowUsersToChangePassword input for this Choreo. 

		@param Boolean - (optional, boolean) Determines whether users can set/change their own passwords. Valid values: "true" or "false" (the default).
		*/
		public void set_AllowUsersToChangePassword(Boolean value) {
			this.setInput("AllowUsersToChangePassword", value);
		}

		/** 
		Set the value of the AllowUsersToChangePassword input for this Choreo as a String. 

		@param String - (optional, boolean) Determines whether users can set/change their own passwords. Valid values: "true" or "false" (the default).
		*/
		public void set_AllowUsersToChangePassword(String value) {
			this.setInput("AllowUsersToChangePassword", value);	
		}
		/** 
		Set the value of the ExpirePasswords input for this Choreo. 

		@param Boolean - (optional, boolean) Determines whether the passwords expire. Valid values: "true" or "false" (the default).
		*/
		public void set_ExpirePasswords(Boolean value) {
			this.setInput("ExpirePasswords", value);
		}

		/** 
		Set the value of the ExpirePasswords input for this Choreo as a String. 

		@param String - (optional, boolean) Determines whether the passwords expire. Valid values: "true" or "false" (the default).
		*/
		public void set_ExpirePasswords(String value) {
			this.setInput("ExpirePasswords", value);	
		}
		/** 
		Set the value of the MaxPasswordsAge input for this Choreo. 

		@param Integer - (optional, integer) Maximum age of the passwords before they expire.
		*/
		public void set_MaxPasswordsAge(Integer value) {
			this.setInput("MaxPasswordsAge", value);
		}

		/** 
		Set the value of the MaxPasswordsAge input for this Choreo as a String. 

		@param String - (optional, integer) Maximum age of the passwords before they expire.
		*/
		public void set_MaxPasswordsAge(String value) {
			this.setInput("MaxPasswordsAge", value);	
		}
		/** 
		Set the value of the MinimumPasswordLength input for this Choreo. 

		@param Integer - (optional, integer) Mininum length of the password. Defaults to none.
		*/
		public void set_MinimumPasswordLength(Integer value) {
			this.setInput("MinimumPasswordLength", value);
		}

		/** 
		Set the value of the MinimumPasswordLength input for this Choreo as a String. 

		@param String - (optional, integer) Mininum length of the password. Defaults to none.
		*/
		public void set_MinimumPasswordLength(String value) {
			this.setInput("MinimumPasswordLength", value);	
		}
		/** 
		Set the value of the RequireLowercaseCharacters input for this Choreo. 

		@param Boolean - (optional, boolean) Determines whether at least one lower-case character is required in the password. Valid values: "true" or "false" (the default).
		*/
		public void set_RequireLowercaseCharacters(Boolean value) {
			this.setInput("RequireLowercaseCharacters", value);
		}

		/** 
		Set the value of the RequireLowercaseCharacters input for this Choreo as a String. 

		@param String - (optional, boolean) Determines whether at least one lower-case character is required in the password. Valid values: "true" or "false" (the default).
		*/
		public void set_RequireLowercaseCharacters(String value) {
			this.setInput("RequireLowercaseCharacters", value);	
		}
		/** 
		Set the value of the RequireNumbers input for this Choreo. 

		@param Boolean - (optional, boolean) Determines whether numbers are required in the password. Valid values: "true" or "false" (the default).
		*/
		public void set_RequireNumbers(Boolean value) {
			this.setInput("RequireNumbers", value);
		}

		/** 
		Set the value of the RequireNumbers input for this Choreo as a String. 

		@param String - (optional, boolean) Determines whether numbers are required in the password. Valid values: "true" or "false" (the default).
		*/
		public void set_RequireNumbers(String value) {
			this.setInput("RequireNumbers", value);	
		}
		/** 
		Set the value of the RequireSymbols input for this Choreo. 

		@param Boolean - (optional, boolean) Determines whether symbols are required in the password. Valid values: "true" or "false" (the default).
		*/
		public void set_RequireSymbols(Boolean value) {
			this.setInput("RequireSymbols", value);
		}

		/** 
		Set the value of the RequireSymbols input for this Choreo as a String. 

		@param String - (optional, boolean) Determines whether symbols are required in the password. Valid values: "true" or "false" (the default).
		*/
		public void set_RequireSymbols(String value) {
			this.setInput("RequireSymbols", value);	
		}
		/** 
		Set the value of the RequireUppercaseCharacters input for this Choreo. 

		@param Boolean - (optional, boolean) Determines whether at least one upper-case character is required in the password. Valid values: "true" or "false" (the default).
		*/
		public void set_RequireUppercaseCharacters(Boolean value) {
			this.setInput("RequireUppercaseCharacters", value);
		}

		/** 
		Set the value of the RequireUppercaseCharacters input for this Choreo as a String. 

		@param String - (optional, boolean) Determines whether at least one upper-case character is required in the password. Valid values: "true" or "false" (the default).
		*/
		public void set_RequireUppercaseCharacters(String value) {
			this.setInput("RequireUppercaseCharacters", value);	
		}
		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the UpdateAccountPasswordPolicy Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class UpdateAccountPasswordPolicyResultSet extends ResultSet {
		public UpdateAccountPasswordPolicyResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Amazon.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
