package com.temboo.Library.Amazon.DynamoDB;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
PutItem

Creates a new item, or replaces an old item with a new item.
*/
public class PutItem extends Choreography {

	/**
	Create a new instance of the PutItem Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public PutItem(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Amazon/DynamoDB/PutItem"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return PutItemInputSet
	*/
	public PutItemInputSet newInputSet() {
		return new PutItemInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public PutItemResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new PutItemResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the PutItem
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class PutItemInputSet extends InputSet {
		/** 
		Set the value of the AWSAccessKeyId input for this Choreo. 

		@param String - (required, string) The Access Key ID provided by Amazon Web Services.
		*/
		public void set_AWSAccessKeyId(String value) {
			this.setInput("AWSAccessKeyId", value);
		}


		/** 
		Set the value of the AWSSecretKeyId input for this Choreo. 

		@param String - (required, string) The Secret Key ID provided by Amazon Web Services.
		*/
		public void set_AWSSecretKeyId(String value) {
			this.setInput("AWSSecretKeyId", value);
		}


		/** 
		Set the value of the ConditionExpression input for this Choreo. 

		@param String - (optional, string) A condition that must be satisfied in order for a conditional PutItem operation to succeed.
		*/
		public void set_ConditionExpression(String value) {
			this.setInput("ConditionExpression", value);
		}


		/** 
		Set the value of the ExpressionAttributeNames input for this Choreo. 

		@param String - (optional, json) One or more substitution tokens for attribute names in an expression.
		*/
		public void set_ExpressionAttributeNames(String value) {
			this.setInput("ExpressionAttributeNames", value);
		}


		/** 
		Set the value of the ExpressionAttributeValues input for this Choreo. 

		@param String - (optional, json) One or more values that can be substituted in an expression.
		*/
		public void set_ExpressionAttributeValues(String value) {
			this.setInput("ExpressionAttributeValues", value);
		}


		/** 
		Set the value of the Item input for this Choreo. 

		@param String - (required, json) A map of attribute name/value pairs, one for each attribute. Only the primary key attributes are required.
		*/
		public void set_Item(String value) {
			this.setInput("Item", value);
		}


		/** 
		Set the value of the ReturnConsumedCapacity input for this Choreo. 

		@param String - (optional, string) Determines the level of detail about provisioned throughput consumption that is returned in the response. Valid values are: INDEXES, TOTAL, NONE.
		*/
		public void set_ReturnConsumedCapacity(String value) {
			this.setInput("ReturnConsumedCapacity", value);
		}


		/** 
		Set the value of the ReturnItemCollectionMetrics input for this Choreo. 

		@param String - (optional, string) Determines whether item collection metrics are returned. Valid values are: SIZE and NONE.
		*/
		public void set_ReturnItemCollectionMetrics(String value) {
			this.setInput("ReturnItemCollectionMetrics", value);
		}


		/** 
		Set the value of the ReturnValues input for this Choreo. 

		@param String - (optional, string) Use ReturnValues if you want to get the item attributes as they appeared before they were updated with the PutItem request. Valid values are NONE and ALL_OLD.
		*/
		public void set_ReturnValues(String value) {
			this.setInput("ReturnValues", value);
		}


		/** 
		Set the value of the TableName input for this Choreo. 

		@param String - (required, string) The name of the table to contain the item.
		*/
		public void set_TableName(String value) {
			this.setInput("TableName", value);
		}


		/** 
		Set the value of the UserRegion input for this Choreo. 

		@param String - (optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
		*/
		public void set_UserRegion(String value) {
			this.setInput("UserRegion", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the PutItem Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class PutItemResultSet extends ResultSet {
		public PutItemResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Amazon.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
