package com.temboo.Library.Wordnik.WordLists;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
CreateWordList

Creates a new word list for the specified user.
*/
public class CreateWordList extends Choreography {

	/**
	Create a new instance of the CreateWordList Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public CreateWordList(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Wordnik/WordLists/CreateWordList"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return CreateWordListInputSet
	*/
	public CreateWordListInputSet newInputSet() {
		return new CreateWordListInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public CreateWordListResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new CreateWordListResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the CreateWordList
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class CreateWordListInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key obtained from Wordnik.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the ListDescription input for this Choreo. 

		@param String - (required, string) A description of the list to create.
		*/
		public void set_ListDescription(String value) {
			this.setInput("ListDescription", value);
		}


		/** 
		Set the value of the ListName input for this Choreo. 

		@param String - (required, string) Name of list to create.
		*/
		public void set_ListName(String value) {
			this.setInput("ListName", value);
		}


		/** 
		Set the value of the ListStatus input for this Choreo. 

		@param String - (optional, string) Determines whether the list to cretae is public or private. Acceptable values: PUBLIC or PRIVATE.
		*/
		public void set_ListStatus(String value) {
			this.setInput("ListStatus", value);
		}


		/** 
		Set the value of the Password input for this Choreo. 

		@param String - (required, string) The Password of the Wordnik account.
		*/
		public void set_Password(String value) {
			this.setInput("Password", value);
		}


		/** 
		Set the value of the Username input for this Choreo. 

		@param String - (required, string) The Username of the Wordnik account.
		*/
		public void set_Username(String value) {
			this.setInput("Username", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the CreateWordList Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class CreateWordListResultSet extends ResultSet {
		public CreateWordListResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Wordnik.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
