package com.temboo.Library.Twitter.PlacesAndGeo;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GeoSearch

Searches for places that can be attached to a status update using a latitude and a longitude pair, an IP address, or a name.
*/
public class GeoSearch extends Choreography {

	/**
	Create a new instance of the GeoSearch Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GeoSearch(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Twitter/PlacesAndGeo/GeoSearch"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GeoSearchInputSet
	*/
	public GeoSearchInputSet newInputSet() {
		return new GeoSearchInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GeoSearchResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GeoSearchResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GeoSearch
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GeoSearchInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) The Access Token provided by Twitter or retrieved during the OAuth process.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the AccessTokenSecret input for this Choreo. 

		@param String - (required, string) The Access Token Secret provided by Twitter or retrieved during the OAuth process.
		*/
		public void set_AccessTokenSecret(String value) {
			this.setInput("AccessTokenSecret", value);
		}


		/** 
		Set the value of the Accuracy input for this Choreo. 

		@param String - (optional, string) A hint on the "region" in which to search. If a number, then this is a radius in meters. You can also specify feet by using the ft suffix (i.e. 5ft).
		*/
		public void set_Accuracy(String value) {
			this.setInput("Accuracy", value);
		}


		/** 
		Set the value of the Callback input for this Choreo. 

		@param String - (optional, string) If supplied, the response will use the JSONP format with a callback of the given name.
		*/
		public void set_Callback(String value) {
			this.setInput("Callback", value);
		}


		/** 
		Set the value of the ConsumerKey input for this Choreo. 

		@param String - (required, string) The API Key (or Consumer Key) provided by Twitter.
		*/
		public void set_ConsumerKey(String value) {
			this.setInput("ConsumerKey", value);
		}


		/** 
		Set the value of the ConsumerSecret input for this Choreo. 

		@param String - (required, string) The API Secret (or Consumer Secret) provided by Twitter.
		*/
		public void set_ConsumerSecret(String value) {
			this.setInput("ConsumerSecret", value);
		}


		/** 
		Set the value of the ContainedWithin input for this Choreo. 

		@param String - (optional, string) This is the place_id which you would like to restrict the search results to. This id can be retrieved with the GetPlaceInformation Choreo.
		*/
		public void set_ContainedWithin(String value) {
			this.setInput("ContainedWithin", value);
		}


		/** 
		Set the value of the Granularity input for this Choreo. 

		@param String - (optional, string) This is the minimal granularity of place types to return and must be one of: poi, neighborhood, city, admin or country. Defaults to neighborhood.
		*/
		public void set_Granularity(String value) {
			this.setInput("Granularity", value);
		}


		/** 
		Set the value of the IP input for this Choreo. 

		@param String - (conditional, string) An IP address. Used when attempting to fix geolocation based off of the user's IP address. You must provide Latitude and Longitude, IP, or Query.
		*/
		public void set_IP(String value) {
			this.setInput("IP", value);
		}


		/** 
		Set the value of the Latitude input for this Choreo. 

		@param BigDecimal - (conditional, decimal) The latitude to search around. You must provide Latitude and Longitude, IP, or Query.
		*/
		public void set_Latitude(BigDecimal value) {
			this.setInput("Latitude", value);
		}

		/** 
		Set the value of the Latitude input for this Choreo as a String. 

		@param String - (conditional, decimal) The latitude to search around. You must provide Latitude and Longitude, IP, or Query.
		*/
		public void set_Latitude(String value) {
			this.setInput("Latitude", value);	
		}
		/** 
		Set the value of the Longitude input for this Choreo. 

		@param BigDecimal - (conditional, decimal) The longitude to search around. You must provide Latitude and Longitude, IP, or Query.
		*/
		public void set_Longitude(BigDecimal value) {
			this.setInput("Longitude", value);
		}

		/** 
		Set the value of the Longitude input for this Choreo as a String. 

		@param String - (conditional, decimal) The longitude to search around. You must provide Latitude and Longitude, IP, or Query.
		*/
		public void set_Longitude(String value) {
			this.setInput("Longitude", value);	
		}
		/** 
		Set the value of the MaxResults input for this Choreo. 

		@param Integer - (optional, integer) The maximum number of results to return.
		*/
		public void set_MaxResults(Integer value) {
			this.setInput("MaxResults", value);
		}

		/** 
		Set the value of the MaxResults input for this Choreo as a String. 

		@param String - (optional, integer) The maximum number of results to return.
		*/
		public void set_MaxResults(String value) {
			this.setInput("MaxResults", value);	
		}
		/** 
		Set the value of the Query input for this Choreo. 

		@param String - (conditional, string) Free-form text to match against while executing a geo-based query. You must provide Latitude and Longitude, IP, or Query.
		*/
		public void set_Query(String value) {
			this.setInput("Query", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GeoSearch Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GeoSearchResultSet extends ResultSet {
		public GeoSearchResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Limit" output from this Choreo execution

		@return String - (integer) The rate limit ceiling for this particular request.
		*/
		public String get_Limit() {
			return this.getResultString("Limit");
		}
		/** 
		Retrieve the value for the "Remaining" output from this Choreo execution

		@return String - (integer) The number of requests left for the 15 minute window.
		*/
		public String get_Remaining() {
			return this.getResultString("Remaining");
		}
		/** 
		Retrieve the value for the "Reset" output from this Choreo execution

		@return String - (date) The remaining window before the rate limit resets in UTC epoch seconds.
		*/
		public String get_Reset() {
			return this.getResultString("Reset");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Twitter.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
