package com.temboo.Library.Yelp;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
SearchByAddress

Retrieve businesses within a specific range of a specified address.
*/
public class SearchByAddress extends Choreography {

	/**
	Create a new instance of the SearchByAddress Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public SearchByAddress(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Yelp/SearchByAddress"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return SearchByAddressInputSet
	*/
	public SearchByAddressInputSet newInputSet() {
		return new SearchByAddressInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public SearchByAddressResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new SearchByAddressResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the SearchByAddress
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class SearchByAddressInputSet extends InputSet {
		/** 
		Set the value of the Address input for this Choreo. 

		@param String - (required, string) The street address of the business to search for.
		*/
		public void set_Address(String value) {
			this.setInput("Address", value);
		}


		/** 
		Set the value of the BusinessType input for this Choreo. 

		@param String - (optional, string) A term to narrow the search, such as "wine" or "restaurants". Leave blank to search for all business types.
		*/
		public void set_BusinessType(String value) {
			this.setInput("BusinessType", value);
		}


		/** 
		Set the value of the Category input for this Choreo. 

		@param String - (optional, string) The category to filter search results with. This can be a list of comma delimited categories. For example, "bars,french". See Choreo description for a list of categories.
		*/
		public void set_Category(String value) {
			this.setInput("Category", value);
		}


		/** 
		Set the value of the ConsumerKey input for this Choreo. 

		@param String - (required, string) The Consumer Key provided by Yelp.
		*/
		public void set_ConsumerKey(String value) {
			this.setInput("ConsumerKey", value);
		}


		/** 
		Set the value of the ConsumerSecret input for this Choreo. 

		@param String - (required, string) The Consumer Secret provided by Yelp.
		*/
		public void set_ConsumerSecret(String value) {
			this.setInput("ConsumerSecret", value);
		}


		/** 
		Set the value of the Count input for this Choreo. 

		@param Integer - (optional, integer) The number of business results to return. The maxiumum is 20.
		*/
		public void set_Count(Integer value) {
			this.setInput("Count", value);
		}

		/** 
		Set the value of the Count input for this Choreo as a String. 

		@param String - (optional, integer) The number of business results to return. The maxiumum is 20.
		*/
		public void set_Count(String value) {
			this.setInput("Count", value);	
		}
		/** 
		Set the value of the CountryCode input for this Choreo. 

		@param String - (optional, string) The ISO 3166-1 2-digit country code to use when parsing the location field. United States = US, Canada = CA, United Kingdom = GB.
		*/
		public void set_CountryCode(String value) {
			this.setInput("CountryCode", value);
		}


		/** 
		Set the value of the Deals input for this Choreo. 

		@param Boolean - (optional, boolean) Set to "true" to exclusively search for businesses with deals.
		*/
		public void set_Deals(Boolean value) {
			this.setInput("Deals", value);
		}

		/** 
		Set the value of the Deals input for this Choreo as a String. 

		@param String - (optional, boolean) Set to "true" to exclusively search for businesses with deals.
		*/
		public void set_Deals(String value) {
			this.setInput("Deals", value);	
		}
		/** 
		Set the value of the LanguageCode input for this Choreo. 

		@param String - (optional, string) The ISO 639 language code. Default to "en". Reviews and snippets written in the specified language will be returned.
		*/
		public void set_LanguageCode(String value) {
			this.setInput("LanguageCode", value);
		}


		/** 
		Set the value of the Offset input for this Choreo. 

		@param String - (optional, string) Offsets the list of returned business results by this amount.
		*/
		public void set_Offset(String value) {
			this.setInput("Offset", value);
		}


		/** 
		Set the value of the Range input for this Choreo. 

		@param Integer - (optional, integer) Narrow or expand a search by specifying a range in either feet, meters, miles, or kilometers, depending on the value of the Units input. Maximum is 25 miles (40000 meters).
		*/
		public void set_Range(Integer value) {
			this.setInput("Range", value);
		}

		/** 
		Set the value of the Range input for this Choreo as a String. 

		@param String - (optional, integer) Narrow or expand a search by specifying a range in either feet, meters, miles, or kilometers, depending on the value of the Units input. Maximum is 25 miles (40000 meters).
		*/
		public void set_Range(String value) {
			this.setInput("Range", value);	
		}
		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format of the response from Yelp, either XML or JSON (the default).
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the Sort input for this Choreo. 

		@param Integer - (optional, integer) The sort mode: 0 = Best matched, 1 = Distance (default), 2 = Highest Rated.
		*/
		public void set_Sort(Integer value) {
			this.setInput("Sort", value);
		}

		/** 
		Set the value of the Sort input for this Choreo as a String. 

		@param String - (optional, integer) The sort mode: 0 = Best matched, 1 = Distance (default), 2 = Highest Rated.
		*/
		public void set_Sort(String value) {
			this.setInput("Sort", value);	
		}
		/** 
		Set the value of the Token input for this Choreo. 

		@param String - (required, string) The Token provided by Yelp.
		*/
		public void set_Token(String value) {
			this.setInput("Token", value);
		}


		/** 
		Set the value of the TokenSecret input for this Choreo. 

		@param String - (required, string) The Token Secret provided by Yelp.
		*/
		public void set_TokenSecret(String value) {
			this.setInput("TokenSecret", value);
		}


		/** 
		Set the value of the Units input for this Choreo. 

		@param String - (optional, string) Specify "feet" (the default), "meters", "miles", or "kilometers". Units apply to the Range input value.
		*/
		public void set_Units(String value) {
			this.setInput("Units", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the SearchByAddress Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class SearchByAddressResultSet extends ResultSet {
		public SearchByAddressResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Yelp. Corresponds to the input value for ResponseFormat (defaults to JSON).
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
