package com.temboo.Library.Google.Spreadsheets;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
SearchColumn

Searches a column for a specified value.
*/
public class SearchColumn extends Choreography {

	/**
	Create a new instance of the SearchColumn Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public SearchColumn(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Google/Spreadsheets/SearchColumn"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return SearchColumnInputSet
	*/
	public SearchColumnInputSet newInputSet() {
		return new SearchColumnInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public SearchColumnResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new SearchColumnResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the SearchColumn
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class SearchColumnInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (optional, string) A valid Access Token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new Access Token.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the ClientID input for this Choreo. 

		@param String - (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
		*/
		public void set_ClientID(String value) {
			this.setInput("ClientID", value);
		}


		/** 
		Set the value of the ClientSecret input for this Choreo. 

		@param String - (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
		*/
		public void set_ClientSecret(String value) {
			this.setInput("ClientSecret", value);
		}


		/** 
		Set the value of the Password input for this Choreo. 

		@param String - (optional, password) Deprecated (retained for backward compatibility only).
		*/
		public void set_Password(String value) {
			this.setInput("Password", value);
		}


		/** 
		Set the value of the RefreshToken input for this Choreo. 

		@param String - (conditional, string) An OAuth Refresh Token used to generate a new Access Token when the original token is expired. Required unless providing a valid AccessToken.
		*/
		public void set_RefreshToken(String value) {
			this.setInput("RefreshToken", value);
		}


		/** 
		Set the value of the ReturnMatches input for this Choreo. 

		@param Boolean - (optional, boolean) Set to true to return all matches of the query. When set to true, an array of cell values that meet the query criteria is returned in the Results output. Defaults to true.
		*/
		public void set_ReturnMatches(Boolean value) {
			this.setInput("ReturnMatches", value);
		}

		/** 
		Set the value of the ReturnMatches input for this Choreo as a String. 

		@param String - (optional, boolean) Set to true to return all matches of the query. When set to true, an array of cell values that meet the query criteria is returned in the Results output. Defaults to true.
		*/
		public void set_ReturnMatches(String value) {
			this.setInput("ReturnMatches", value);	
		}
		/** 
		Set the value of the SearchColumn input for this Choreo. 

		@param String - (required, string) The name of the column to search. This should be the value in row 1 of the column you wish to search.
		*/
		public void set_SearchColumn(String value) {
			this.setInput("SearchColumn", value);
		}


		/** 
		Set the value of the SearchOperator input for this Choreo. 

		@param String - (required, string) The operator to use in the query. Allowed operators are: >, <, >=, >=, =, contains, and starts_with.
		*/
		public void set_SearchOperator(String value) {
			this.setInput("SearchOperator", value);
		}


		/** 
		Set the value of the SearchValue input for this Choreo. 

		@param String - (required, any) The value to search for in the specified column.
		*/
		public void set_SearchValue(String value) {
			this.setInput("SearchValue", value);
		}


		/** 
		Set the value of the SpreadsheetKey input for this Choreo. 

		@param String - (conditional, string) The unique key of the spreadsheet to query. Required unless SpreadsheetName and WorksheetName are supplied.
		*/
		public void set_SpreadsheetKey(String value) {
			this.setInput("SpreadsheetKey", value);
		}


		/** 
		Set the value of the SpreadsheetName input for this Choreo. 

		@param String - (optional, string) The name of the spreadsheet to query. This and WorksheetName can be used as an alternative to SpreadsheetKey and WorksheetId to lookup spreadsheet details by name.
		*/
		public void set_SpreadsheetName(String value) {
			this.setInput("SpreadsheetName", value);
		}


		/** 
		Set the value of the Username input for this Choreo. 

		@param String - (optional, string) Deprecated (retained for backward compatibility only).
		*/
		public void set_Username(String value) {
			this.setInput("Username", value);
		}


		/** 
		Set the value of the WorksheetId input for this Choreo. 

		@param String - (conditional, string) The unique ID of the worksheet to query. Required unless SpreadsheetName and WorksheetName are supplied.
		*/
		public void set_WorksheetId(String value) {
			this.setInput("WorksheetId", value);
		}


		/** 
		Set the value of the WorksheetName input for this Choreo. 

		@param String - (optional, string) The name of the worksheet to query. This and SpreadsheetName can be used as an alternative to SpreadsheetKey and WorksheetId to lookup the spreadsheet details by name.
		*/
		public void set_WorksheetName(String value) {
			this.setInput("WorksheetName", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the SearchColumn Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class SearchColumnResultSet extends ResultSet {
		public SearchColumnResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "MatchFound" output from this Choreo execution

		@return String - (boolean) Whether or not a matched result was found.
		*/
		public String get_MatchFound() {
			return this.getResultString("MatchFound");
		}
		/** 
		Retrieve the value for the "Count" output from this Choreo execution

		@return String - (integer) The count of matched results. This is only returned when ReturnMatches is set to true.
		*/
		public String get_Count() {
			return this.getResultString("Count");
		}
		/** 
		Retrieve the value for the "NewAccessToken" output from this Choreo execution

		@return String - (string) Contains a new AccessToken when the RefreshToken is provided.
		*/
		public String get_NewAccessToken() {
			return this.getResultString("NewAccessToken");
		}
		/** 
		Retrieve the value for the "Results" output from this Choreo execution

		@return String - (json) Contains an array of the matched cell values. This is only returned when ReturnMatches is set to true.
		*/
		public String get_Results() {
			return this.getResultString("Results");
		}
	}
	
}
