package com.temboo.Library.Google.Spreadsheets;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
AddListRows

Adds one or more rows to a worksheet in a Google spreadsheet using a simple XML file you provide.
*/
public class AddListRows extends Choreography {

	/**
	Create a new instance of the AddListRows Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public AddListRows(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Google/Spreadsheets/AddListRows"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return AddListRowsInputSet
	*/
	public AddListRowsInputSet newInputSet() {
		return new AddListRowsInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public AddListRowsResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new AddListRowsResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the AddListRows
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class AddListRowsInputSet extends InputSet {
		/** 
		Set the value of the RowsetXML input for this Choreo. 

		@param String - (required, xml) The rows of data that you want to add to a worksheet in XML format. Your XML needs to be in the rowset/row schema described in the Choreo documentation.
		*/
		public void set_RowsetXML(String value) {
			this.setInput("RowsetXML", value);
		}


		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (optional, string) A valid Access Token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new Access Token.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the ClientID input for this Choreo. 

		@param String - (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
		*/
		public void set_ClientID(String value) {
			this.setInput("ClientID", value);
		}


		/** 
		Set the value of the ClientSecret input for this Choreo. 

		@param String - (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
		*/
		public void set_ClientSecret(String value) {
			this.setInput("ClientSecret", value);
		}


		/** 
		Set the value of the Password input for this Choreo. 

		@param String - (optional, password) Deprecated (retained for backward compatibility only).
		*/
		public void set_Password(String value) {
			this.setInput("Password", value);
		}


		/** 
		Set the value of the RefreshToken input for this Choreo. 

		@param String - (conditional, string) An OAuth Refresh Token used to generate a new Access Token when the original token is expired. Required unless providing a valid AccessToken.
		*/
		public void set_RefreshToken(String value) {
			this.setInput("RefreshToken", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are: xml (the default) and json.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the SpreadsheetKey input for this Choreo. 

		@param String - (required, string) The unique key of the spreadsheet that contains the worksheet you want to add rows to.
		*/
		public void set_SpreadsheetKey(String value) {
			this.setInput("SpreadsheetKey", value);
		}


		/** 
		Set the value of the Username input for this Choreo. 

		@param String - (optional, string) Deprecated (retained for backward compatibility only).
		*/
		public void set_Username(String value) {
			this.setInput("Username", value);
		}


		/** 
		Set the value of the WorksheetId input for this Choreo. 

		@param String - (required, string) The unique ID of the worksheet that you want to add rows to.
		*/
		public void set_WorksheetId(String value) {
			this.setInput("WorksheetId", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the AddListRows Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class AddListRowsResultSet extends ResultSet {
		public AddListRowsResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "NewAccessToken" output from this Choreo execution

		@return String - (string) Contains a new AccessToken when the RefreshToken is provided.
		*/
		public String get_NewAccessToken() {
			return this.getResultString("NewAccessToken");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Google.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
