package com.temboo.Library.Google.Contacts;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetAllContacts

Retrieve data for all contacts in an account.
*/
public class GetAllContacts extends Choreography {

	/**
	Create a new instance of the GetAllContacts Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetAllContacts(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Google/Contacts/GetAllContacts"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetAllContactsInputSet
	*/
	public GetAllContactsInputSet newInputSet() {
		return new GetAllContactsInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetAllContactsResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetAllContactsResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetAllContacts
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetAllContactsInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (optional, string) The access token retrieved in the last step of the OAuth process. Access tokens that are expired will be refreshed and returned in the Choreo output.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the ClientID input for this Choreo. 

		@param String - (required, string) The client ID provided by Google when you register your application.
		*/
		public void set_ClientID(String value) {
			this.setInput("ClientID", value);
		}


		/** 
		Set the value of the ClientSecret input for this Choreo. 

		@param String - (required, string) The client secret provided by Google when you registered your application.
		*/
		public void set_ClientSecret(String value) {
			this.setInput("ClientSecret", value);
		}


		/** 
		Set the value of the Group input for this Choreo. 

		@param String - (optional, string) Constrains the results to only the contacts belonging to the group specified. The value of this parameter specifies group ID.
		*/
		public void set_Group(String value) {
			this.setInput("Group", value);
		}


		/** 
		Set the value of the MaxResults input for this Choreo. 

		@param Integer - (optional, integer) The maximum number of entries to return.
		*/
		public void set_MaxResults(Integer value) {
			this.setInput("MaxResults", value);
		}

		/** 
		Set the value of the MaxResults input for this Choreo as a String. 

		@param String - (optional, integer) The maximum number of entries to return.
		*/
		public void set_MaxResults(String value) {
			this.setInput("MaxResults", value);	
		}
		/** 
		Set the value of the RefreshToken input for this Choreo. 

		@param String - (required, string) The refresh token retrieved in the last step of the OAuth process. This is used when an access token is expired or not provided.
		*/
		public void set_RefreshToken(String value) {
			this.setInput("RefreshToken", value);
		}


		/** 
		Set the value of the SortOrder input for this Choreo. 

		@param String - (optional, string) Sorting order direction. Can be either ascending or descending.
		*/
		public void set_SortOrder(String value) {
			this.setInput("SortOrder", value);
		}


		/** 
		Set the value of the StartIndex input for this Choreo. 

		@param Integer - (optional, integer) The index of the first result to be retrieved (for paging).
		*/
		public void set_StartIndex(Integer value) {
			this.setInput("StartIndex", value);
		}

		/** 
		Set the value of the StartIndex input for this Choreo as a String. 

		@param String - (optional, integer) The index of the first result to be retrieved (for paging).
		*/
		public void set_StartIndex(String value) {
			this.setInput("StartIndex", value);	
		}
		/** 
		Set the value of the UpdatedMin input for this Choreo. 

		@param String - (optional, date) The lower bound on entry update dates to filter by (e.g., 2015-01-16T00:00:00).
		*/
		public void set_UpdatedMin(String value) {
			this.setInput("UpdatedMin", value);
		}


		/** 
		Set the value of the UserEmail input for this Choreo. 

		@param String - (optional, string) The email address of the user whose contacts you want to retrieve. Defaults to "default," or the user whose OAuth access token is passed.
		*/
		public void set_UserEmail(String value) {
			this.setInput("UserEmail", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetAllContacts Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetAllContactsResultSet extends ResultSet {
		public GetAllContactsResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "AccessToken" output from this Choreo execution

		@return String - (optional, string) The access token retrieved in the last step of the OAuth process. Access tokens that are expired will be refreshed and returned in the Choreo output.
		*/
		public String get_AccessToken() {
			return this.getResultString("AccessToken");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (xml) The response from Google.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
