package com.temboo.Library.FedEx.Locations;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
SearchLocationsByAddress

Searches for FedEx locations near a given address.
*/
public class SearchLocationsByAddress extends Choreography {

	/**
	Create a new instance of the SearchLocationsByAddress Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public SearchLocationsByAddress(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/FedEx/Locations/SearchLocationsByAddress"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return SearchLocationsByAddressInputSet
	*/
	public SearchLocationsByAddressInputSet newInputSet() {
		return new SearchLocationsByAddressInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public SearchLocationsByAddressResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new SearchLocationsByAddressResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the SearchLocationsByAddress
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class SearchLocationsByAddressInputSet extends InputSet {
		/** 
		Set the value of the AccountNumber input for this Choreo. 

		@param String - (required, string) Your FedEx Account Number or Test Account Number.
		*/
		public void set_AccountNumber(String value) {
			this.setInput("AccountNumber", value);
		}


		/** 
		Set the value of the AuthenticationKey input for this Choreo. 

		@param String - (required, string) The Production Authentication Key or Development Test Key provided by FedEx Web Services.
		*/
		public void set_AuthenticationKey(String value) {
			this.setInput("AuthenticationKey", value);
		}


		/** 
		Set the value of the City input for this Choreo. 

		@param String - (required, string) The city associated with the location being searched.
		*/
		public void set_City(String value) {
			this.setInput("City", value);
		}


		/** 
		Set the value of the CountryCode input for this Choreo. 

		@param String - (required, string) The country code associated with the location being searched (e.g., US).
		*/
		public void set_CountryCode(String value) {
			this.setInput("CountryCode", value);
		}


		/** 
		Set the value of the Endpoint input for this Choreo. 

		@param String - (conditional, string) Set to "test" to direct requests to the FedEx test environment. Defaults to "production" indicating that requests are sent to the production URL.
		*/
		public void set_Endpoint(String value) {
			this.setInput("Endpoint", value);
		}


		/** 
		Set the value of the MeterNumber input for this Choreo. 

		@param String - (required, string) The Production or Test Meter Number provided by FedEx Web Services.
		*/
		public void set_MeterNumber(String value) {
			this.setInput("MeterNumber", value);
		}


		/** 
		Set the value of the Password input for this Choreo. 

		@param String - (required, password) The Production or Test Password provided by FedEx Web Services.
		*/
		public void set_Password(String value) {
			this.setInput("Password", value);
		}


		/** 
		Set the value of the PostalCode input for this Choreo. 

		@param String - (required, string) The postal code associated with the location being searched.
		*/
		public void set_PostalCode(String value) {
			this.setInput("PostalCode", value);
		}


		/** 
		Set the value of the RadiusDistance input for this Choreo. 

		@param BigDecimal - (optional, decimal) Specifies value of the radius around the address to search for FedEx locations. Note that RadiusUnits applies to this value. Defaults to 10 miles.
		*/
		public void set_RadiusDistance(BigDecimal value) {
			this.setInput("RadiusDistance", value);
		}

		/** 
		Set the value of the RadiusDistance input for this Choreo as a String. 

		@param String - (optional, decimal) Specifies value of the radius around the address to search for FedEx locations. Note that RadiusUnits applies to this value. Defaults to 10 miles.
		*/
		public void set_RadiusDistance(String value) {
			this.setInput("RadiusDistance", value);	
		}
		/** 
		Set the value of the RadiusUnits input for this Choreo. 

		@param String - (optional, string) Specifies the unit of measure for the RadiusDistance value. Valid values are mi (the default) and km.
		*/
		public void set_RadiusUnits(String value) {
			this.setInput("RadiusUnits", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the SortBy input for this Choreo. 

		@param String - (optional, string) Specifies the criterion to be used to sort the location details. Valid values are: distance (the default), latest_express_dropoff_time, latest_ground_dropoff_time, location_type.
		*/
		public void set_SortBy(String value) {
			this.setInput("SortBy", value);
		}


		/** 
		Set the value of the SortOrder input for this Choreo. 

		@param String - (optional, string) Specifies sort order of the location details. Valid values are: lowest_to_highest (the default) and highest_to_lowest.
		*/
		public void set_SortOrder(String value) {
			this.setInput("SortOrder", value);
		}


		/** 
		Set the value of the State input for this Choreo. 

		@param String - (required, string) Identifying abbreviation for US state, Canada province (e.g., NY).
		*/
		public void set_State(String value) {
			this.setInput("State", value);
		}


		/** 
		Set the value of the Street input for this Choreo. 

		@param String - (required, string) The street number and street name (e.g., 350 5th Ave).
		*/
		public void set_Street(String value) {
			this.setInput("Street", value);
		}


		/** 
		Set the value of the SupportedServices input for this Choreo. 

		@param String - (optional, string) Specifies the types of services supported by a FedEx location for redirect to hold. Valid values are: fedex_express, fedex_ground, fedex_ground_home_delivery.
		*/
		public void set_SupportedServices(String value) {
			this.setInput("SupportedServices", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the SearchLocationsByAddress Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class SearchLocationsByAddressResultSet extends ResultSet {
		public SearchLocationsByAddressResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from FedEx.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
