package com.temboo.Library.Zoho.CRM;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
DeleteRecords

Deletes a specified record from a Zoho CRM account.
*/
public class DeleteRecords extends Choreography {

	/**
	Create a new instance of the DeleteRecords Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public DeleteRecords(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Zoho/CRM/DeleteRecords"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return DeleteRecordsInputSet
	*/
	public DeleteRecordsInputSet newInputSet() {
		return new DeleteRecordsInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public DeleteRecordsResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new DeleteRecordsResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the DeleteRecords
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class DeleteRecordsInputSet extends InputSet {
		/** 
		Set the value of the AuthenticationToken input for this Choreo. 

		@param String - (required, string) A valid authentication token. Permanent authentication tokens can be generated by the GenerateAuthToken Choreo.
		*/
		public void set_AuthenticationToken(String value) {
			this.setInput("AuthenticationToken", value);
		}


		/** 
		Set the value of the ID input for this Choreo. 

		@param Integer - (required, integer) The ID for the record you want to delete
		*/
		public void set_ID(Integer value) {
			this.setInput("ID", value);
		}

		/** 
		Set the value of the ID input for this Choreo as a String. 

		@param String - (required, integer) The ID for the record you want to delete
		*/
		public void set_ID(String value) {
			this.setInput("ID", value);	
		}
		/** 
		Set the value of the Module input for this Choreo. 

		@param String - (optional, string) The Zoho module you want to access. Defaults to Leads.
		*/
		public void set_Module(String value) {
			this.setInput("Module", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid formats are: json and xml (the default).
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the DeleteRecords Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class DeleteRecordsResultSet extends ResultSet {
		public DeleteRecordsResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Zoho. Format corresponds to the ResponseFormat input. Defaults to xml.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
