package com.temboo.Library.Zoho.CRM;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
ConvertLead

Converts a lead to a potential, account, or contact in your Zoho CRM account.
*/
public class ConvertLead extends Choreography {

	/**
	Create a new instance of the ConvertLead Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public ConvertLead(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Zoho/CRM/ConvertLead"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ConvertLeadInputSet
	*/
	public ConvertLeadInputSet newInputSet() {
		return new ConvertLeadInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ConvertLeadResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ConvertLeadResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the ConvertLead
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ConvertLeadInputSet extends InputSet {
		/** 
		Set the value of the Amount input for this Choreo. 

		@param BigDecimal - (conditional, decimal) Corresponds to the Amount field in Zoho. Required if CreatePotential is set to 1.
		*/
		public void set_Amount(BigDecimal value) {
			this.setInput("Amount", value);
		}

		/** 
		Set the value of the Amount input for this Choreo as a String. 

		@param String - (conditional, decimal) Corresponds to the Amount field in Zoho. Required if CreatePotential is set to 1.
		*/
		public void set_Amount(String value) {
			this.setInput("Amount", value);	
		}
		/** 
		Set the value of the AssignTo input for this Choreo. 

		@param String - (optional, string) Corresponds to the Assign To field in Zoho
		*/
		public void set_AssignTo(String value) {
			this.setInput("AssignTo", value);
		}


		/** 
		Set the value of the AuthenticationToken input for this Choreo. 

		@param String - (required, string) A valid authentication token. Permanent authentication tokens can be generated by the GenerateAuthToken Choreo.
		*/
		public void set_AuthenticationToken(String value) {
			this.setInput("AuthenticationToken", value);
		}


		/** 
		Set the value of the ClosingDate input for this Choreo. 

		@param String - (conditional, date) Corresponds to the Closing Date field in Zoho. Formatted like MM/dd/yyyy. Required if CreatePotential is set to 1.
		*/
		public void set_ClosingDate(String value) {
			this.setInput("ClosingDate", value);
		}


		/** 
		Set the value of the ContactRole input for this Choreo. 

		@param String - (conditional, string) Corresponds to the Contact Role field in Zoho. Required if CreatePotential is set to 1.
		*/
		public void set_ContactRole(String value) {
			this.setInput("ContactRole", value);
		}


		/** 
		Set the value of the CreatePotential input for this Choreo. 

		@param Boolean - (optional, boolean) Whether or not to create a potential
		*/
		public void set_CreatePotential(Boolean value) {
			this.setInput("CreatePotential", value);
		}

		/** 
		Set the value of the CreatePotential input for this Choreo as a String. 

		@param String - (optional, boolean) Whether or not to create a potential
		*/
		public void set_CreatePotential(String value) {
			this.setInput("CreatePotential", value);	
		}
		/** 
		Set the value of the ID input for this Choreo. 

		@param Integer - (required, integer) The ID for the lead that you wish to convert to a potential
		*/
		public void set_ID(Integer value) {
			this.setInput("ID", value);
		}

		/** 
		Set the value of the ID input for this Choreo as a String. 

		@param String - (required, integer) The ID for the lead that you wish to convert to a potential
		*/
		public void set_ID(String value) {
			this.setInput("ID", value);	
		}
		/** 
		Set the value of the NotifyLeadOwner input for this Choreo. 

		@param Boolean - (optional, boolean) Whether or not to notifiy the lead owner. Defaults to 0 for false.
		*/
		public void set_NotifyLeadOwner(Boolean value) {
			this.setInput("NotifyLeadOwner", value);
		}

		/** 
		Set the value of the NotifyLeadOwner input for this Choreo as a String. 

		@param String - (optional, boolean) Whether or not to notifiy the lead owner. Defaults to 0 for false.
		*/
		public void set_NotifyLeadOwner(String value) {
			this.setInput("NotifyLeadOwner", value);	
		}
		/** 
		Set the value of the NotifyNewEntityOwner input for this Choreo. 

		@param Boolean - (optional, boolean) Whether or not to notify the new entity owner. Defaults to 0 for false.
		*/
		public void set_NotifyNewEntityOwner(Boolean value) {
			this.setInput("NotifyNewEntityOwner", value);
		}

		/** 
		Set the value of the NotifyNewEntityOwner input for this Choreo as a String. 

		@param String - (optional, boolean) Whether or not to notify the new entity owner. Defaults to 0 for false.
		*/
		public void set_NotifyNewEntityOwner(String value) {
			this.setInput("NotifyNewEntityOwner", value);	
		}
		/** 
		Set the value of the PotentialName input for this Choreo. 

		@param String - (conditional, string) Corresponds to the Potential Name field in Zoho. Required if CreatePotential is set to 1.
		*/
		public void set_PotentialName(String value) {
			this.setInput("PotentialName", value);
		}


		/** 
		Set the value of the PotentialStage input for this Choreo. 

		@param String - (conditional, string) Corresponds to the Potential Stage field in Zoho. Required if CreatePotential is set to 1.
		*/
		public void set_PotentialStage(String value) {
			this.setInput("PotentialStage", value);
		}


		/** 
		Set the value of the Probability input for this Choreo. 

		@param Integer - (conditional, integer) Corresponds to the Probability field in Zoho. Required if CreatePotential is set to 1.
		*/
		public void set_Probability(Integer value) {
			this.setInput("Probability", value);
		}

		/** 
		Set the value of the Probability input for this Choreo as a String. 

		@param String - (conditional, integer) Corresponds to the Probability field in Zoho. Required if CreatePotential is set to 1.
		*/
		public void set_Probability(String value) {
			this.setInput("Probability", value);	
		}
		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid formats are: json and xml (the default).
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the ConvertLead Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ConvertLeadResultSet extends ResultSet {
		public ConvertLeadResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Zoho. Format corresponds to the ResponseFormat input. Defaults to xml.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
