package com.temboo.Library.Instapaper;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
AddURL

Add a document to an Instapaper account.
*/
public class AddURL extends Choreography {

	/**
	Create a new instance of the AddURL Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public AddURL(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Instapaper/AddURL"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return AddURLInputSet
	*/
	public AddURLInputSet newInputSet() {
		return new AddURLInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public AddURLResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new AddURLResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the AddURL
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class AddURLInputSet extends InputSet {
		/** 
		Set the value of the Password input for this Choreo. 

		@param String - (required, password) Your Instapaper password.
		*/
		public void set_Password(String value) {
			this.setInput("Password", value);
		}


		/** 
		Set the value of the Selection input for this Choreo. 

		@param String - (optional, string) Enter a description of the URL being added.
		*/
		public void set_Selection(String value) {
			this.setInput("Selection", value);
		}


		/** 
		Set the value of the Title input for this Choreo. 

		@param String - (optional, string) Enter a titile for the uploaded URL. If no title is provided, Instapaper will crawl the URL to detect a title.
		*/
		public void set_Title(String value) {
			this.setInput("Title", value);
		}


		/** 
		Set the value of the URL input for this Choreo. 

		@param String - (required, string) Enter the URL of the document that is being added to an Instapaper account.
		*/
		public void set_URL(String value) {
			this.setInput("URL", value);
		}


		/** 
		Set the value of the Username input for this Choreo. 

		@param String - (required, string) Your Instapaper username.
		*/
		public void set_Username(String value) {
			this.setInput("Username", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the AddURL Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class AddURLResultSet extends ResultSet {
		public AddURLResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (integer) The response from Instapaper. Successful reqests will return a 201 status code.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
