package com.temboo.Library.Zillow;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetDeepSearchResults

Retrieve comprehensive property information for a specified address. 
*/
public class GetDeepSearchResults extends Choreography {

	/**
	Create a new instance of the GetDeepSearchResults Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetDeepSearchResults(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Zillow/GetDeepSearchResults"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetDeepSearchResultsInputSet
	*/
	public GetDeepSearchResultsInputSet newInputSet() {
		return new GetDeepSearchResultsInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetDeepSearchResultsResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetDeepSearchResultsResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetDeepSearchResults
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetDeepSearchResultsInputSet extends InputSet {
		/** 
		Set the value of the Address input for this Choreo. 

		@param String - (required, string) Enter the address of the property to search.
		*/
		public void set_Address(String value) {
			this.setInput("Address", value);
		}


		/** 
		Set the value of the City input for this Choreo. 

		@param String - (required, string) Enter a city name.
		*/
		public void set_City(String value) {
			this.setInput("City", value);
		}


		/** 
		Set the value of the RentEstimate input for this Choreo. 

		@param Boolean - (optional, boolean) Set to 1 (true) to enable. Defaults to 0 (false).
		*/
		public void set_RentEstimate(Boolean value) {
			this.setInput("RentEstimate", value);
		}

		/** 
		Set the value of the RentEstimate input for this Choreo as a String. 

		@param String - (optional, boolean) Set to 1 (true) to enable. Defaults to 0 (false).
		*/
		public void set_RentEstimate(String value) {
			this.setInput("RentEstimate", value);	
		}
		/** 
		Set the value of the State input for this Choreo. 

		@param String - (required, string) Enter a State abbreviation. If State is set, an entry for City must also be entered.
		*/
		public void set_State(String value) {
			this.setInput("State", value);
		}


		/** 
		Set the value of the ZWSID input for this Choreo. 

		@param String - (required, string) Enter a Zillow Web Service Identifier (ZWS ID).
		*/
		public void set_ZWSID(String value) {
			this.setInput("ZWSID", value);
		}


		/** 
		Set the value of the Zipcode input for this Choreo. 

		@param Integer - (required, integer) Enter a zipcode. Can be combined with or without the  City and State input variables.
		*/
		public void set_Zipcode(Integer value) {
			this.setInput("Zipcode", value);
		}

		/** 
		Set the value of the Zipcode input for this Choreo as a String. 

		@param String - (required, integer) Enter a zipcode. Can be combined with or without the  City and State input variables.
		*/
		public void set_Zipcode(String value) {
			this.setInput("Zipcode", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetDeepSearchResults Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetDeepSearchResultsResultSet extends ResultSet {
		public GetDeepSearchResultsResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (xml) The response from Zillow.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
