package com.temboo.Library.KhanAcademy.Exercises;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetExerciseVideos

Retrieves all videos associated with a given exercise.
*/
public class GetExerciseVideos extends Choreography {

	/**
	Create a new instance of the GetExerciseVideos Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetExerciseVideos(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/KhanAcademy/Exercises/GetExerciseVideos"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetExerciseVideosInputSet
	*/
	public GetExerciseVideosInputSet newInputSet() {
		return new GetExerciseVideosInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetExerciseVideosResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetExerciseVideosResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetExerciseVideos
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetExerciseVideosInputSet extends InputSet {
		/** 
		Set the value of the ExerciseName input for this Choreo. 

		@param String - (required, string) The name of the exercise to retrieve (e.g. logarithms_1)
		*/
		public void set_ExerciseName(String value) {
			this.setInput("ExerciseName", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetExerciseVideos Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetExerciseVideosResultSet extends ResultSet {
		public GetExerciseVideosResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Khan Academy.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
