package com.temboo.Library.KhanAcademy.Badges;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
BadgesByCategory

Retrieves all badges for a specific category.
*/
public class BadgesByCategory extends Choreography {

	/**
	Create a new instance of the BadgesByCategory Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public BadgesByCategory(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/KhanAcademy/Badges/BadgesByCategory"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return BadgesByCategoryInputSet
	*/
	public BadgesByCategoryInputSet newInputSet() {
		return new BadgesByCategoryInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public BadgesByCategoryResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new BadgesByCategoryResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the BadgesByCategory
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class BadgesByCategoryInputSet extends InputSet {
		/** 
		Set the value of the CategoryID input for this Choreo. 

		@param String - (required, string) The category of badges to retrieve. A full list of CategoryIds can be obtained by running the AllCategories Choreo.
		*/
		public void set_CategoryID(String value) {
			this.setInput("CategoryID", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the BadgesByCategory Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class BadgesByCategoryResultSet extends ResultSet {
		public BadgesByCategoryResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Khan Academy.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
