package com.temboo.Library.Foursquare.Checkins;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetNearbyFriends

Returns a list of recent friends' check-ins that are nearby the specified location.
*/
public class GetNearbyFriends extends Choreography {

	/**
	Create a new instance of the GetNearbyFriends Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetNearbyFriends(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Foursquare/Checkins/GetNearbyFriends"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetNearbyFriendsInputSet
	*/
	public GetNearbyFriendsInputSet newInputSet() {
		return new GetNearbyFriendsInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetNearbyFriendsResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetNearbyFriendsResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetNearbyFriends
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetNearbyFriendsInputSet extends InputSet {
		/** 
		Set the value of the Distance input for this Choreo. 

		@param Integer - (optional, integer) The distance (in meters) between the supplied coordinates and the checkin location. This returns friends' checkins where the distance is less than or equal to this value. Default is 500.
		*/
		public void set_Distance(Integer value) {
			this.setInput("Distance", value);
		}

		/** 
		Set the value of the Distance input for this Choreo as a String. 

		@param String - (optional, integer) The distance (in meters) between the supplied coordinates and the checkin location. This returns friends' checkins where the distance is less than or equal to this value. Default is 500.
		*/
		public void set_Distance(String value) {
			this.setInput("Distance", value);	
		}
		/** 
		Set the value of the Latitude input for this Choreo. 

		@param BigDecimal - (required, decimal) The latitude point of the user's location.
		*/
		public void set_Latitude(BigDecimal value) {
			this.setInput("Latitude", value);
		}

		/** 
		Set the value of the Latitude input for this Choreo as a String. 

		@param String - (required, decimal) The latitude point of the user's location.
		*/
		public void set_Latitude(String value) {
			this.setInput("Latitude", value);	
		}
		/** 
		Set the value of the Limit input for this Choreo. 

		@param Integer - (optional, integer) Number of results to return, up to 100.
		*/
		public void set_Limit(Integer value) {
			this.setInput("Limit", value);
		}

		/** 
		Set the value of the Limit input for this Choreo as a String. 

		@param String - (optional, integer) Number of results to return, up to 100.
		*/
		public void set_Limit(String value) {
			this.setInput("Limit", value);	
		}
		/** 
		Set the value of the Longitude input for this Choreo. 

		@param BigDecimal - (required, decimal) The longitude point of the user's location.
		*/
		public void set_Longitude(BigDecimal value) {
			this.setInput("Longitude", value);
		}

		/** 
		Set the value of the Longitude input for this Choreo as a String. 

		@param String - (required, decimal) The longitude point of the user's location.
		*/
		public void set_Longitude(String value) {
			this.setInput("Longitude", value);	
		}
		/** 
		Set the value of the OauthToken input for this Choreo. 

		@param String - (required, string) The Foursquare API OAuth token string.
		*/
		public void set_OauthToken(String value) {
			this.setInput("OauthToken", value);
		}


		/** 
		Set the value of the ResponseMode input for this Choreo. 

		@param String - (optional, string) Used to simplify the response. Valid values are: simple and verbose. When set to simple, an array of user objects are returned. Verbose mode returns an array of checkin objects. Defaults to "simple".
		*/
		public void set_ResponseMode(String value) {
			this.setInput("ResponseMode", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetNearbyFriends Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetNearbyFriendsResultSet extends ResultSet {
		public GetNearbyFriendsResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Foursquare. Corresponds to the ResponseFormat input. Defaults to JSON.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
