package com.temboo.Library.CorpWatch.Company;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetCompanyHistory

Returns a complete set of basic records for a given company, covering all the years for which information is available.
*/
public class GetCompanyHistory extends Choreography {

	/**
	Create a new instance of the GetCompanyHistory Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetCompanyHistory(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/CorpWatch/Company/GetCompanyHistory"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetCompanyHistoryInputSet
	*/
	public GetCompanyHistoryInputSet newInputSet() {
		return new GetCompanyHistoryInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetCompanyHistoryResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetCompanyHistoryResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetCompanyHistory
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetCompanyHistoryInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (optional, string) The APIKey from CorpWatch if you have one.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the CWID input for this Choreo. 

		@param String - (required, string) CoprWatch ID for the company. Format looks like: cw_8484.
		*/
		public void set_CWID(String value) {
			this.setInput("CWID", value);
		}


		/** 
		Set the value of the ResponseType input for this Choreo. 

		@param String - (optional, string) Specify json or xml for the type of response to be returned. Defaults to xml.
		*/
		public void set_ResponseType(String value) {
			this.setInput("ResponseType", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetCompanyHistory Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetCompanyHistoryResultSet extends ResultSet {
		public GetCompanyHistoryResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from CorpWatch.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
