package com.temboo.Library.LastFm.User;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
Shout

Creates a message in a user's shoutbox 
*/
public class Shout extends Choreography {

	/**
	Create a new instance of the Shout Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public Shout(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/LastFm/User/Shout"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ShoutInputSet
	*/
	public ShoutInputSet newInputSet() {
		return new ShoutInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ShoutResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ShoutResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the Shout
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ShoutInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) Your Last.fm API Key.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the APISecret input for this Choreo. 

		@param String - (required, string) Your Last.fm API Secret.
		*/
		public void set_APISecret(String value) {
			this.setInput("APISecret", value);
		}


		/** 
		Set the value of the Message input for this Choreo. 

		@param String - (required, string) The message to post to the shoutbox.
		*/
		public void set_Message(String value) {
			this.setInput("Message", value);
		}


		/** 
		Set the value of the SessionKey input for this Choreo. 

		@param String - (required, string) The session key retrieved in the last step of the authorization process.
		*/
		public void set_SessionKey(String value) {
			this.setInput("SessionKey", value);
		}


		/** 
		Set the value of the User input for this Choreo. 

		@param String - (required, string) The name of the user to shout on.
		*/
		public void set_User(String value) {
			this.setInput("User", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the Shout Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ShoutResultSet extends ResultSet {
		public ShoutResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (xml) The response from Last.fm.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
