package com.temboo.Library.Dwolla.Transactions;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
Request

Use this method to request funds from a source user, originating from the user associated with the authorized access token.
*/
public class Request extends Choreography {

	/**
	Create a new instance of the Request Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public Request(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Dwolla/Transactions/Request"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return RequestInputSet
	*/
	public RequestInputSet newInputSet() {
		return new RequestInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public RequestResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new RequestResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the Request
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class RequestInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) A valid OAuth token.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the Amount input for this Choreo. 

		@param BigDecimal - (required, decimal) Amount of funds to request from the source user.
		*/
		public void set_Amount(BigDecimal value) {
			this.setInput("Amount", value);
		}

		/** 
		Set the value of the Amount input for this Choreo as a String. 

		@param String - (required, decimal) Amount of funds to request from the source user.
		*/
		public void set_Amount(String value) {
			this.setInput("Amount", value);	
		}
		/** 
		Set the value of the FacillitatorAmount input for this Choreo. 

		@param BigDecimal - (optional, decimal) Amount of the facilitator fee to override. Only applicable if the facilitator fee feature is enabled. If set to 0, facilitator fee is disabled for transaction. Cannot exceed 25% of the 'amount'.
		*/
		public void set_FacillitatorAmount(BigDecimal value) {
			this.setInput("FacillitatorAmount", value);
		}

		/** 
		Set the value of the FacillitatorAmount input for this Choreo as a String. 

		@param String - (optional, decimal) Amount of the facilitator fee to override. Only applicable if the facilitator fee feature is enabled. If set to 0, facilitator fee is disabled for transaction. Cannot exceed 25% of the 'amount'.
		*/
		public void set_FacillitatorAmount(String value) {
			this.setInput("FacillitatorAmount", value);	
		}
		/** 
		Set the value of the Notes input for this Choreo. 

		@param String - (optional, multiline) Note to attach to the transaction. Limited to 250 characters.
		*/
		public void set_Notes(String value) {
			this.setInput("Notes", value);
		}


		/** 
		Set the value of the Pin input for this Choreo. 

		@param Integer - (required, integer) User's PIN associated with their account.
		*/
		public void set_Pin(Integer value) {
			this.setInput("Pin", value);
		}

		/** 
		Set the value of the Pin input for this Choreo as a String. 

		@param String - (required, integer) User's PIN associated with their account.
		*/
		public void set_Pin(String value) {
			this.setInput("Pin", value);	
		}
		/** 
		Set the value of the SourceID input for this Choreo. 

		@param String - (required, string) Identification of the user to request funds from. Must be the Dwolla identifier, Facebook identifier, Twitter screename, phone number, or email address.
		*/
		public void set_SourceID(String value) {
			this.setInput("SourceID", value);
		}


		/** 
		Set the value of the SourceType input for this Choreo. 

		@param String - (optional, string) Type of destination user. Defaults to Dwolla. Can be Dwolla, Facebook, Twitter, Email, or Phone.
		*/
		public void set_SourceType(String value) {
			this.setInput("SourceType", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the Request Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class RequestResultSet extends ResultSet {
		public RequestResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Dwolla.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
