package com.temboo.Library.SendGrid.WebAPI.Profile;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
UpdateAccountProfile

Update a SendGrid account profile.
*/
public class UpdateAccountProfile extends Choreography {

	/**
	Create a new instance of the UpdateAccountProfile Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public UpdateAccountProfile(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/SendGrid/WebAPI/Profile/UpdateAccountProfile"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return UpdateAccountProfileInputSet
	*/
	public UpdateAccountProfileInputSet newInputSet() {
		return new UpdateAccountProfileInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public UpdateAccountProfileResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new UpdateAccountProfileResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the UpdateAccountProfile
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class UpdateAccountProfileInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key obtained from SendGrid.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the APIUser input for this Choreo. 

		@param String - (required, string) The username registered with SendGrid.
		*/
		public void set_APIUser(String value) {
			this.setInput("APIUser", value);
		}


		/** 
		Set the value of the Address input for this Choreo. 

		@param String - (optional, string) The company address.
		*/
		public void set_Address(String value) {
			this.setInput("Address", value);
		}


		/** 
		Set the value of the City input for this Choreo. 

		@param String - (optional, string) The city where this address is located in.
		*/
		public void set_City(String value) {
			this.setInput("City", value);
		}


		/** 
		Set the value of the FirstName input for this Choreo. 

		@param String - (optional, string) The first name of the profile being updated.
		*/
		public void set_FirstName(String value) {
			this.setInput("FirstName", value);
		}


		/** 
		Set the value of the LastName input for this Choreo. 

		@param String - (optional, string) The last name of the profile being updated.
		*/
		public void set_LastName(String value) {
			this.setInput("LastName", value);
		}


		/** 
		Set the value of the Phone input for this Choreo. 

		@param String - (optional, string) The phone number, where you can be reached.
		*/
		public void set_Phone(String value) {
			this.setInput("Phone", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format of the response from SendGrid, in either json, or xml.  Default is set to json.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the State input for this Choreo. 

		@param String - (optional, string) The state where this company is located in.
		*/
		public void set_State(String value) {
			this.setInput("State", value);
		}


		/** 
		Set the value of the Website input for this Choreo. 

		@param String - (optional, string) The company's website.
		*/
		public void set_Website(String value) {
			this.setInput("Website", value);
		}


		/** 
		Set the value of the Zip input for this Choreo. 

		@param String - (optional, string) The zipcode where this company is located.
		*/
		public void set_Zip(String value) {
			this.setInput("Zip", value);
		}


		/** 
		Set the value of the VaultFile input for this Choreo. 

		@param TembooPath - 
		*/

	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the UpdateAccountProfile Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class UpdateAccountProfileResultSet extends ResultSet {
		public UpdateAccountProfileResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from SendGrid. The format corresponds to the ResponseFormat input. Default is json.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
