package com.temboo.Library.Labs.GoodCitizen;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
EcoByZip

Returns a host of eco-conscious environmental information for a specified location based on zip code.
*/
public class EcoByZip extends Choreography {

	/**
	Create a new instance of the EcoByZip Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public EcoByZip(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Labs/GoodCitizen/EcoByZip"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return EcoByZipInputSet
	*/
	public EcoByZipInputSet newInputSet() {
		return new EcoByZipInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public EcoByZipResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new EcoByZipResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the EcoByZip
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class EcoByZipInputSet extends InputSet {
		/** 
		Set the value of the APICredentials input for this Choreo. 

		@param String - (optional, string) A JSON dictionary containing credentials for Genability. See Choreo documentation for formatting examples.
		*/
		public void set_APICredentials(String value) {
			this.setInput("APICredentials", value);
		}


		/** 
		Set the value of the Limit input for this Choreo. 

		@param Integer - (optional, integer) The number of facility records to search for in the Envirofacts database.
		*/
		public void set_Limit(Integer value) {
			this.setInput("Limit", value);
		}

		/** 
		Set the value of the Limit input for this Choreo as a String. 

		@param String - (optional, integer) The number of facility records to search for in the Envirofacts database.
		*/
		public void set_Limit(String value) {
			this.setInput("Limit", value);	
		}
		/** 
		Set the value of the Zip input for this Choreo. 

		@param Integer - (required, integer) The zip code for the user's current location.
		*/
		public void set_Zip(Integer value) {
			this.setInput("Zip", value);
		}

		/** 
		Set the value of the Zip input for this Choreo as a String. 

		@param String - (required, integer) The zip code for the user's current location.
		*/
		public void set_Zip(String value) {
			this.setInput("Zip", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the EcoByZip Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class EcoByZipResultSet extends ResultSet {
		public EcoByZipResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from the Eco Choreo.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
