package com.temboo.Library.Dropbox.Files;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
UploadSessionStart

Allows you to upload a single file in one or more requests. This call starts a new upload session with the first chunk of data.
*/
public class UploadSessionStart extends Choreography {

	/**
	Create a new instance of the UploadSessionStart Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public UploadSessionStart(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Dropbox/Files/UploadSessionStart"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return UploadSessionStartInputSet
	*/
	public UploadSessionStartInputSet newInputSet() {
		return new UploadSessionStartInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public UploadSessionStartResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new UploadSessionStartResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the UploadSessionStart
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class UploadSessionStartInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) The access token for a specific Dropbox user.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the Close input for this Choreo. 

		@param Boolean - (optional, boolean) If true, the current session will be closed, at which point you won't be able to call UploadSessionAppend anymore with the current session. The default for this field is false.
		*/
		public void set_Close(Boolean value) {
			this.setInput("Close", value);
		}

		/** 
		Set the value of the Close input for this Choreo as a String. 

		@param String - (optional, boolean) If true, the current session will be closed, at which point you won't be able to call UploadSessionAppend anymore with the current session. The default for this field is false.
		*/
		public void set_Close(String value) {
			this.setInput("Close", value);	
		}
		/** 
		Set the value of the ContentType input for this Choreo. 

		@param String - (optional, string) The content type of the file being uploaded. Defaults to application/octet-stream.
		*/
		public void set_ContentType(String value) {
			this.setInput("ContentType", value);
		}


		/** 
		Set the value of the FileContent input for this Choreo. 

		@param String - (conditional, string) The first file segment to upload. Binary files should be Base64-encoded. Encoding is not required when ContentType is set to "text/plain".
		*/
		public void set_FileContent(String value) {
			this.setInput("FileContent", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the UploadSessionStart Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class UploadSessionStartResultSet extends ResultSet {
		public UploadSessionStartResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "SessionID" output from this Choreo execution

		@return String - (string) The upload session ID that can be used to append to the upload or finish the upload.
		*/
		public String get_SessionID() {
			return this.getResultString("SessionID");
		}
	}
	
}
