package com.temboo.Library.Facebook.Searching;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
URLLookup

Performs a lookup for a Facebook page by URL.
*/
public class URLLookup extends Choreography {

	/**
	Create a new instance of the URLLookup Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public URLLookup(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Facebook/Searching/URLLookup"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return URLLookupInputSet
	*/
	public URLLookupInputSet newInputSet() {
		return new URLLookupInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public URLLookupResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new URLLookupResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the URLLookup
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class URLLookupInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) The access token retrieved from the final OAuth step.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the Fields input for this Choreo. 

		@param String - (optional, string) A comma separated list of fields to return (i.e. id,name).
		*/
		public void set_Fields(String value) {
			this.setInput("Fields", value);
		}


		/** 
		Set the value of the IDs input for this Choreo. 

		@param String - (required, string) One or more Open Graph Object URLs. Multiple URLs should be separated by commas.
		*/
		public void set_IDs(String value) {
			this.setInput("IDs", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the URLLookup Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class URLLookupResultSet extends ResultSet {
		public URLLookupResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Facebook.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
