package com.temboo.Library.Yahoo.YQL;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
RunQuery

Executes a specified YQL (Yahoo Query Language) statement.
*/
public class RunQuery extends Choreography {

	/**
	Create a new instance of the RunQuery Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public RunQuery(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Yahoo/YQL/RunQuery"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return RunQueryInputSet
	*/
	public RunQueryInputSet newInputSet() {
		return new RunQueryInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public RunQueryResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new RunQueryResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the RunQuery
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class RunQueryInputSet extends InputSet {
		/** 
		Set the value of the Diagnostics input for this Choreo. 

		@param Boolean - (optional, boolean) When set to "true" (the default), additional debug information about the request is returned.
		*/
		public void set_Diagnostics(Boolean value) {
			this.setInput("Diagnostics", value);
		}

		/** 
		Set the value of the Diagnostics input for this Choreo as a String. 

		@param String - (optional, boolean) When set to "true" (the default), additional debug information about the request is returned.
		*/
		public void set_Diagnostics(String value) {
			this.setInput("Diagnostics", value);	
		}
		/** 
		Set the value of the Query input for this Choreo. 

		@param String - (required, string) A YQL (Yahoo! Query Language) statement to execute.
		*/
		public void set_Query(String value) {
			this.setInput("Query", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the RunQuery Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class RunQueryResultSet extends ResultSet {
		public RunQueryResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Yahoo.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
