package com.temboo.Library.Yahoo.PlaceFinder;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
FindByAddress

Retrieves complete geocoding information for a location by specifying an address or partial address.
*/
public class FindByAddress extends Choreography {

	/**
	Create a new instance of the FindByAddress Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public FindByAddress(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Yahoo/PlaceFinder/FindByAddress"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return FindByAddressInputSet
	*/
	public FindByAddressInputSet newInputSet() {
		return new FindByAddressInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public FindByAddressResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new FindByAddressResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the FindByAddress
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class FindByAddressInputSet extends InputSet {
		/** 
		Set the value of the Address input for this Choreo. 

		@param String - (required, string) The address to be searched.
		*/
		public void set_Address(String value) {
			this.setInput("Address", value);
		}


		/** 
		Set the value of the AppID input for this Choreo. 

		@param String - (optional, string) Deprecated (retained for backward compatibility only).
		*/
		public void set_AppID(String value) {
			this.setInput("AppID", value);
		}


		/** 
		Set the value of the GeocodeFlags input for this Choreo. 

		@param String - (optional, string) Affects how geocoding is performed for the request. Valid value are: A, C, L, Q, or R. See documentation for more details on this parameter.
		*/
		public void set_GeocodeFlags(String value) {
			this.setInput("GeocodeFlags", value);
		}


		/** 
		Set the value of the ResponseFlags input for this Choreo. 

		@param String - (optional, string) Determines which data elements are returned in the response. Valid values are: B, C, D, E, G, I, J, Q, R, T, U, W, X. See documentation for details on this parameter.
		*/
		public void set_ResponseFlags(String value) {
			this.setInput("ResponseFlags", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are: xml (the default) and json.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the FindByAddress Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class FindByAddressResultSet extends ResultSet {
		public FindByAddressResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Latitude" output from this Choreo execution

		@return String - (decimal) The latitude coordinate for the location.
		*/
		public String get_Latitude() {
			return this.getResultString("Latitude");
		}
		/** 
		Retrieve the value for the "Longitude" output from this Choreo execution

		@return String - (decimal) The longitude coordinate for the location.
		*/
		public String get_Longitude() {
			return this.getResultString("Longitude");
		}
		/** 
		Retrieve the value for the "WOEID" output from this Choreo execution

		@return String - (integer) The unique Where On Earth ID of the location.
		*/
		public String get_WOEID() {
			return this.getResultString("WOEID");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Yahoo PlaceFinder.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
