package com.temboo.Library.NPR.StationFinder;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
SearchByZipCode

Retrieves local NPR member stations based on zip code.
*/
public class SearchByZipCode extends Choreography {

	/**
	Create a new instance of the SearchByZipCode Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public SearchByZipCode(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/NPR/StationFinder/SearchByZipCode"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return SearchByZipCodeInputSet
	*/
	public SearchByZipCodeInputSet newInputSet() {
		return new SearchByZipCodeInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public SearchByZipCodeResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new SearchByZipCodeResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the SearchByZipCode
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class SearchByZipCodeInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key provided by NPR.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are xml (the default), and json.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the Zip input for this Choreo. 

		@param String - (required, string) Enter a five-digit zip code.
		*/
		public void set_Zip(String value) {
			this.setInput("Zip", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the SearchByZipCode Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class SearchByZipCodeResultSet extends ResultSet {
		public SearchByZipCodeResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from NPR.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
