package com.temboo.Library.Nexmo.Account;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
UpdateNumber

Updates the callback details for the specified number.
*/
public class UpdateNumber extends Choreography {

	/**
	Create a new instance of the UpdateNumber Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public UpdateNumber(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Nexmo/Account/UpdateNumber"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return UpdateNumberInputSet
	*/
	public UpdateNumberInputSet newInputSet() {
		return new UpdateNumberInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public UpdateNumberResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new UpdateNumberResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the UpdateNumber
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class UpdateNumberInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) Your API Key provided to you by Nexmo.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the APISecret input for this Choreo. 

		@param String - (required, string) Your API Secret provided to you by Nexmo.
		*/
		public void set_APISecret(String value) {
			this.setInput("APISecret", value);
		}


		/** 
		Set the value of the CallbackURL input for this Choreo. 

		@param String - (optional, string) Mobile originated Callback URL.
		*/
		public void set_CallbackURL(String value) {
			this.setInput("CallbackURL", value);
		}


		/** 
		Set the value of the Country input for this Choreo. 

		@param String - (required, string) 2-digit country code. (e.g. CA)
		*/
		public void set_Country(String value) {
			this.setInput("Country", value);
		}


		/** 
		Set the value of the Number input for this Choreo. 

		@param String - (required, string) Your inbound (MSISDN) number (e.g. 34911067000).
		*/
		public void set_Number(String value) {
			this.setInput("Number", value);
		}


		/** 
		Set the value of the SMPPSystemType input for this Choreo. 

		@param String - (optional, string) The Mobile Orignated associated system type for SMPP client only. (e.g.: inbound)
		*/
		public void set_SMPPSystemType(String value) {
			this.setInput("SMPPSystemType", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the UpdateNumber Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class UpdateNumberResultSet extends ResultSet {
		public UpdateNumberResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "ResponseStatusCode" output from this Choreo execution

		@return String - (integer) The response status code returned from Nexmo. A 200 is returned for a successful request.
		*/
		public String get_ResponseStatusCode() {
			return this.getResultString("ResponseStatusCode");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Nexmo. For a successful request, an empty response body is returned.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
