package com.temboo.Library.RunKeeper.Nutrition;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
RetrieveEntries

Returns the feed for a user's nutrition entries.
*/
public class RetrieveEntries extends Choreography {

	/**
	Create a new instance of the RetrieveEntries Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public RetrieveEntries(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/RunKeeper/Nutrition/RetrieveEntries"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return RetrieveEntriesInputSet
	*/
	public RetrieveEntriesInputSet newInputSet() {
		return new RetrieveEntriesInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public RetrieveEntriesResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new RetrieveEntriesResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the RetrieveEntries
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class RetrieveEntriesInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) The Access Token retrieved after the final step in the OAuth process.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the Page input for this Choreo. 

		@param Integer - (optional, integer) The page of entries to return. This parameter is used in combination with the PageSize input to page through results. Defaults to 0 (the first page).
		*/
		public void set_Page(Integer value) {
			this.setInput("Page", value);
		}

		/** 
		Set the value of the Page input for this Choreo as a String. 

		@param String - (optional, integer) The page of entries to return. This parameter is used in combination with the PageSize input to page through results. Defaults to 0 (the first page).
		*/
		public void set_Page(String value) {
			this.setInput("Page", value);	
		}
		/** 
		Set the value of the PageSize input for this Choreo. 

		@param Integer - (optional, integer) The number entries to return per page. Defaults to 25.
		*/
		public void set_PageSize(Integer value) {
			this.setInput("PageSize", value);
		}

		/** 
		Set the value of the PageSize input for this Choreo as a String. 

		@param String - (optional, integer) The number entries to return per page. Defaults to 25.
		*/
		public void set_PageSize(String value) {
			this.setInput("PageSize", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the RetrieveEntries Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class RetrieveEntriesResultSet extends ResultSet {
		public RetrieveEntriesResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Next" output from this Choreo execution

		@return String - (integer) The next page of entries that is available. This value can be passed into the Page input while paging through entries.
		*/
		public String get_Next() {
			return this.getResultString("Next");
		}
		/** 
		Retrieve the value for the "Previous" output from this Choreo execution

		@return String - (integer) The previous page of entries that is available. This value can be passed into the Page input while paging through entries.
		*/
		public String get_Previous() {
			return this.getResultString("Previous");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from RunKeeper.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
