package com.temboo.Library.Dropbox.FilesAndMetadata;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetFile

Gets the content and metadata for a specified file.
*/
public class GetFile extends Choreography {

	/**
	Create a new instance of the GetFile Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetFile(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Dropbox/FilesAndMetadata/GetFile"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetFileInputSet
	*/
	public GetFileInputSet newInputSet() {
		return new GetFileInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetFileResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetFileResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetFile
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetFileInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) The Access Token retrieved during the OAuth process.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the AccessTokenSecret input for this Choreo. 

		@param String - (required, string) The Access Token Secret retrieved during the OAuth process.
		*/
		public void set_AccessTokenSecret(String value) {
			this.setInput("AccessTokenSecret", value);
		}


		/** 
		Set the value of the AppKey input for this Choreo. 

		@param String - (required, string) The App Key provided by Dropbox (AKA the OAuth Consumer Key).
		*/
		public void set_AppKey(String value) {
			this.setInput("AppKey", value);
		}


		/** 
		Set the value of the AppSecret input for this Choreo. 

		@param String - (required, string) The App Secret provided by Dropbox (AKA the OAuth Consumer Secret).
		*/
		public void set_AppSecret(String value) {
			this.setInput("AppSecret", value);
		}


		/** 
		Set the value of the EncodeFileContent input for this Choreo. 

		@param Boolean - (optional, boolean) File content is returned as Base64 encoded data by default. Text files can be returned as Base64 decoded by setting this input to "false". Note that binary files should always be Base64 encoded.
		*/
		public void set_EncodeFileContent(Boolean value) {
			this.setInput("EncodeFileContent", value);
		}

		/** 
		Set the value of the EncodeFileContent input for this Choreo as a String. 

		@param String - (optional, boolean) File content is returned as Base64 encoded data by default. Text files can be returned as Base64 decoded by setting this input to "false". Note that binary files should always be Base64 encoded.
		*/
		public void set_EncodeFileContent(String value) {
			this.setInput("EncodeFileContent", value);	
		}
		/** 
		Set the value of the IncludeMetadata input for this Choreo. 

		@param Boolean - (optional, boolean) If set to true, metadata about the file is returned. Defaults to false, indicating that only the file content is returned.
		*/
		public void set_IncludeMetadata(Boolean value) {
			this.setInput("IncludeMetadata", value);
		}

		/** 
		Set the value of the IncludeMetadata input for this Choreo as a String. 

		@param String - (optional, boolean) If set to true, metadata about the file is returned. Defaults to false, indicating that only the file content is returned.
		*/
		public void set_IncludeMetadata(String value) {
			this.setInput("IncludeMetadata", value);	
		}
		/** 
		Set the value of the Path input for this Choreo. 

		@param String - (required, string) The path to file you want to retrieve (i.e. RootFolder/SubFolder/MyFile.txt). Only the file name is necessary when the file is at the root level.
		*/
		public void set_Path(String value) {
			this.setInput("Path", value);
		}


		/** 
		Set the value of the Root input for this Choreo. 

		@param String - (optional, string) Defaults to "auto" which automatically determines the root folder using your app's permission level. Other options are "sandbox" (App Folder) and "dropbox" (Full Dropbox).
		*/
		public void set_Root(String value) {
			this.setInput("Root", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetFile Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetFileResultSet extends ResultSet {
		public GetFileResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "FileMetadata" output from this Choreo execution

		@return String - (json) The metadata for the file. This only returned when IncludeMetadata is set to true.
		*/
		public String get_FileMetadata() {
			return this.getResultString("FileMetadata");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (string) The response from Dropbox. The response will contain the contents of the file you are retrieving as Base64 encoded data.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
