package com.temboo.Library.Zendesk.Tickets;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
CreateTicketNewRequester

Creates a new ticket as well as a new requester account.
*/
public class CreateTicketNewRequester extends Choreography {

	/**
	Create a new instance of the CreateTicketNewRequester Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public CreateTicketNewRequester(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Zendesk/Tickets/CreateTicketNewRequester"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return CreateTicketNewRequesterInputSet
	*/
	public CreateTicketNewRequesterInputSet newInputSet() {
		return new CreateTicketNewRequesterInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public CreateTicketNewRequesterResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new CreateTicketNewRequesterResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the CreateTicketNewRequester
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class CreateTicketNewRequesterInputSet extends InputSet {
		/** 
		Set the value of the Comment input for this Choreo. 

		@param String - (required, string) The comment for the ticket that is being created.
		*/
		public void set_Comment(String value) {
			this.setInput("Comment", value);
		}


		/** 
		Set the value of the Email input for this Choreo. 

		@param String - (required, string) The email address you use to login to your Zendesk account.
		*/
		public void set_Email(String value) {
			this.setInput("Email", value);
		}


		/** 
		Set the value of the LocaleID input for this Choreo. 

		@param Integer - (required, integer) LocaleID for the new requester. Indicate 1 for English, 8 for Deutsch, etc.
		*/
		public void set_LocaleID(Integer value) {
			this.setInput("LocaleID", value);
		}

		/** 
		Set the value of the LocaleID input for this Choreo as a String. 

		@param String - (required, integer) LocaleID for the new requester. Indicate 1 for English, 8 for Deutsch, etc.
		*/
		public void set_LocaleID(String value) {
			this.setInput("LocaleID", value);	
		}
		/** 
		Set the value of the Name input for this Choreo. 

		@param String - (required, string) Name of new requester.
		*/
		public void set_Name(String value) {
			this.setInput("Name", value);
		}


		/** 
		Set the value of the Password input for this Choreo. 

		@param String - (required, password) Your Zendesk password.
		*/
		public void set_Password(String value) {
			this.setInput("Password", value);
		}


		/** 
		Set the value of the RequesterEmail input for this Choreo. 

		@param String - (required, string) Email of new requester.
		*/
		public void set_RequesterEmail(String value) {
			this.setInput("RequesterEmail", value);
		}


		/** 
		Set the value of the Server input for this Choreo. 

		@param String - (required, string) Your Zendesk domain and subdomain (e.g., temboocare.zendesk.com).
		*/
		public void set_Server(String value) {
			this.setInput("Server", value);
		}


		/** 
		Set the value of the Subject input for this Choreo. 

		@param String - (required, string) The subject for the ticket that is being created.
		*/
		public void set_Subject(String value) {
			this.setInput("Subject", value);
		}


		/** 
		Set the value of the Token input for this Choreo. 

		@param String - (optional, string) The token associated with an upload to attach to this ticket. Note that tokens can be retrieved by running the UploadFile Choreo.
		*/
		public void set_Token(String value) {
			this.setInput("Token", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the CreateTicketNewRequester Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class CreateTicketNewRequesterResultSet extends ResultSet {
		public CreateTicketNewRequesterResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Zendesk.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
