package com.temboo.Library.PagerDuty.Alerts;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
ListAlerts

List alerts for a given time range and allows you to filter by type.
*/
public class ListAlerts extends Choreography {

	/**
	Create a new instance of the ListAlerts Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public ListAlerts(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/PagerDuty/Alerts/ListAlerts"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ListAlertsInputSet
	*/
	public ListAlertsInputSet newInputSet() {
		return new ListAlertsInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ListAlertsResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ListAlertsResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the ListAlerts
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ListAlertsInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key provided by PagerDuty.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the Filter input for this Choreo. 

		@param String - (optional, string) Returns only alerts of this type. Valid types are: SMS, Email, Phone, or Push.
		*/
		public void set_Filter(String value) {
			this.setInput("Filter", value);
		}


		/** 
		Set the value of the Since input for this Choreo. 

		@param String - (required, date) The start of the date range to search (e.g., 2013-03-06T15:28-05). Note that including the time is optional.
		*/
		public void set_Since(String value) {
			this.setInput("Since", value);
		}


		/** 
		Set the value of the SubDomain input for this Choreo. 

		@param String - (required, string) The subdomain of your PagerDuty site address.
		*/
		public void set_SubDomain(String value) {
			this.setInput("SubDomain", value);
		}


		/** 
		Set the value of the TimeZone input for this Choreo. 

		@param String - (optional, string) The time zone in which dates in the result will be rendered. Defaults to account time zone.
		*/
		public void set_TimeZone(String value) {
			this.setInput("TimeZone", value);
		}


		/** 
		Set the value of the Until input for this Choreo. 

		@param String - (required, date) The end of the date range to search (e.g., 2013-03-06T15:28-05). Note that including the time is optional.
		*/
		public void set_Until(String value) {
			this.setInput("Until", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the ListAlerts Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ListAlertsResultSet extends ResultSet {
		public ListAlertsResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from PagerDuty.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
