package com.temboo.Library.PayPal.Merchant;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
TransactionSearch

Retrieves transaction history for transactions that meet a specified criteria.
*/
public class TransactionSearch extends Choreography {

	/**
	Create a new instance of the TransactionSearch Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public TransactionSearch(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/PayPal/Merchant/TransactionSearch"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return TransactionSearchInputSet
	*/
	public TransactionSearchInputSet newInputSet() {
		return new TransactionSearchInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public TransactionSearchResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new TransactionSearchResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the TransactionSearch
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class TransactionSearchInputSet extends InputSet {
		/** 
		Set the value of the Account input for this Choreo. 

		@param String - (optional, string) Search by credit card number.
		*/
		public void set_Account(String value) {
			this.setInput("Account", value);
		}


		/** 
		Set the value of the AuctionItemNumber input for this Choreo. 

		@param String - (optional, string) Search by auction item number of the purchased item.
		*/
		public void set_AuctionItemNumber(String value) {
			this.setInput("AuctionItemNumber", value);
		}


		/** 
		Set the value of the CurrencyCode input for this Choreo. 

		@param String - (optional, string) Search by currency code (i.e. USD).
		*/
		public void set_CurrencyCode(String value) {
			this.setInput("CurrencyCode", value);
		}


		/** 
		Set the value of the Email input for this Choreo. 

		@param String - (optional, string) Search by email.
		*/
		public void set_Email(String value) {
			this.setInput("Email", value);
		}


		/** 
		Set the value of the EndDate input for this Choreo. 

		@param String - (optional, date) The latest transaction date to return. Must be an epoch timestamp in milliseconds or formatted in UTC like: 2011-05-19T00:00:00Z.
		*/
		public void set_EndDate(String value) {
			this.setInput("EndDate", value);
		}


		/** 
		Set the value of the InvoiceNumber input for this Choreo. 

		@param String - (optional, string) Search by invoice number.
		*/
		public void set_InvoiceNumber(String value) {
			this.setInput("InvoiceNumber", value);
		}


		/** 
		Set the value of the Password input for this Choreo. 

		@param String - (required, password) The API Password provided by PayPal.
		*/
		public void set_Password(String value) {
			this.setInput("Password", value);
		}


		/** 
		Set the value of the ReceiptId input for this Choreo. 

		@param String - (optional, string) Search by the PayPal receipt ID.
		*/
		public void set_ReceiptId(String value) {
			this.setInput("ReceiptId", value);
		}


		/** 
		Set the value of the Receiver input for this Choreo. 

		@param String - (optional, string) Search by the email address of the receiver.
		*/
		public void set_Receiver(String value) {
			this.setInput("Receiver", value);
		}


		/** 
		Set the value of the Signature input for this Choreo. 

		@param String - (required, string) The API Signature provided by PayPal.
		*/
		public void set_Signature(String value) {
			this.setInput("Signature", value);
		}


		/** 
		Set the value of the StartDate input for this Choreo. 

		@param String - (required, date) The earliest transaction date to return. Must be an epoch timestamp in milliseconds or formatted in UTC like: 2011-05-19T00:00:00Z.
		*/
		public void set_StartDate(String value) {
			this.setInput("StartDate", value);
		}


		/** 
		Set the value of the TransactionAmount input for this Choreo. 

		@param BigDecimal - (optional, decimal) Search by transaction amount.
		*/
		public void set_TransactionAmount(BigDecimal value) {
			this.setInput("TransactionAmount", value);
		}

		/** 
		Set the value of the TransactionAmount input for this Choreo as a String. 

		@param String - (optional, decimal) Search by transaction amount.
		*/
		public void set_TransactionAmount(String value) {
			this.setInput("TransactionAmount", value);	
		}
		/** 
		Set the value of the TransactionClass input for this Choreo. 

		@param String - (optional, string) Search by classification of transaction (i.e. All, Sent, Recieved, etc).
		*/
		public void set_TransactionClass(String value) {
			this.setInput("TransactionClass", value);
		}


		/** 
		Set the value of the TransactionId input for this Choreo. 

		@param String - (optional, string) Search by the transaction ID
		*/
		public void set_TransactionId(String value) {
			this.setInput("TransactionId", value);
		}


		/** 
		Set the value of the TransactionStatus input for this Choreo. 

		@param String - (optional, string) Search by transaction status (i.e. Pending, Processing, Success, Denied, Reversed).
		*/
		public void set_TransactionStatus(String value) {
			this.setInput("TransactionStatus", value);
		}


		/** 
		Set the value of the UseSandbox input for this Choreo. 

		@param Boolean - (conditional, boolean) Set to 1 to indicate that you're testing against the PayPal sandbox instead of production. Set to 0 (the default) when moving to production.
		*/
		public void set_UseSandbox(Boolean value) {
			this.setInput("UseSandbox", value);
		}

		/** 
		Set the value of the UseSandbox input for this Choreo as a String. 

		@param String - (conditional, boolean) Set to 1 to indicate that you're testing against the PayPal sandbox instead of production. Set to 0 (the default) when moving to production.
		*/
		public void set_UseSandbox(String value) {
			this.setInput("UseSandbox", value);	
		}
		/** 
		Set the value of the Username input for this Choreo. 

		@param String - (required, string) The API Username provided by PayPal.
		*/
		public void set_Username(String value) {
			this.setInput("Username", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the TransactionSearch Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class TransactionSearchResultSet extends ResultSet {
		public TransactionSearchResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (string) Response from PayPal formatted in name/value pairs.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
