package com.temboo.Library.PayPal.AdaptivePayments;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
ConvertCurrency

Converts a payment amount from one currency to another.
*/
public class ConvertCurrency extends Choreography {

	/**
	Create a new instance of the ConvertCurrency Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public ConvertCurrency(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/PayPal/AdaptivePayments/ConvertCurrency"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ConvertCurrencyInputSet
	*/
	public ConvertCurrencyInputSet newInputSet() {
		return new ConvertCurrencyInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ConvertCurrencyResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ConvertCurrencyResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the ConvertCurrency
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ConvertCurrencyInputSet extends InputSet {
		/** 
		Set the value of the Amount input for this Choreo. 

		@param BigDecimal - (required, decimal) The amount that should be converted to a new currency.
		*/
		public void set_Amount(BigDecimal value) {
			this.setInput("Amount", value);
		}

		/** 
		Set the value of the Amount input for this Choreo as a String. 

		@param String - (required, decimal) The amount that should be converted to a new currency.
		*/
		public void set_Amount(String value) {
			this.setInput("Amount", value);	
		}
		/** 
		Set the value of the AppID input for this Choreo. 

		@param String - (required, string) Your PayPal AppID (or the default AppID for the PayPal sandbox).
		*/
		public void set_AppID(String value) {
			this.setInput("AppID", value);
		}


		/** 
		Set the value of the ConvertToCurrency input for this Choreo. 

		@param String - (required, string) The currency code that you want to convert to (i.e. GBP).
		*/
		public void set_ConvertToCurrency(String value) {
			this.setInput("ConvertToCurrency", value);
		}


		/** 
		Set the value of the CurrencyCode input for this Choreo. 

		@param String - (required, string) The currency code that you want to convert. (i.e. USD).
		*/
		public void set_CurrencyCode(String value) {
			this.setInput("CurrencyCode", value);
		}


		/** 
		Set the value of the Password input for this Choreo. 

		@param String - (required, password) The API Password provided by PayPal.
		*/
		public void set_Password(String value) {
			this.setInput("Password", value);
		}


		/** 
		Set the value of the Signature input for this Choreo. 

		@param String - (required, string) The API Signature provided by PayPal.
		*/
		public void set_Signature(String value) {
			this.setInput("Signature", value);
		}


		/** 
		Set the value of the UseSandbox input for this Choreo. 

		@param Boolean - (conditional, boolean) Set to 1 to indicate that you're testing against the PayPal sandbox instead of production. Set to 0 (the default) when moving to production.
		*/
		public void set_UseSandbox(Boolean value) {
			this.setInput("UseSandbox", value);
		}

		/** 
		Set the value of the UseSandbox input for this Choreo as a String. 

		@param String - (conditional, boolean) Set to 1 to indicate that you're testing against the PayPal sandbox instead of production. Set to 0 (the default) when moving to production.
		*/
		public void set_UseSandbox(String value) {
			this.setInput("UseSandbox", value);	
		}
		/** 
		Set the value of the Username input for this Choreo. 

		@param String - (required, string) The API Username provided by PayPal.
		*/
		public void set_Username(String value) {
			this.setInput("Username", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the ConvertCurrency Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ConvertCurrencyResultSet extends ResultSet {
		public ConvertCurrencyResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from PayPal.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
