package com.temboo.Library.Genability.TariffData;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetMetricsForZipCode

Returns a place object and associated facts and metrics with a given zip code.
*/
public class GetMetricsForZipCode extends Choreography {

	/**
	Create a new instance of the GetMetricsForZipCode Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetMetricsForZipCode(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Genability/TariffData/GetMetricsForZipCode"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetMetricsForZipCodeInputSet
	*/
	public GetMetricsForZipCodeInputSet newInputSet() {
		return new GetMetricsForZipCodeInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetMetricsForZipCodeResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetMetricsForZipCodeResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetMetricsForZipCode
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetMetricsForZipCodeInputSet extends InputSet {
		/** 
		Set the value of the AppID input for this Choreo. 

		@param String - (conditional, string) The App ID provided by Genability.
		*/
		public void set_AppID(String value) {
			this.setInput("AppID", value);
		}


		/** 
		Set the value of the AppKey input for this Choreo. 

		@param String - (required, string) The App Key provided by Genability.
		*/
		public void set_AppKey(String value) {
			this.setInput("AppKey", value);
		}


		/** 
		Set the value of the ZipCode input for this Choreo. 

		@param String - (optional, string) The zip code for the place object you want to return.
		*/
		public void set_ZipCode(String value) {
			this.setInput("ZipCode", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetMetricsForZipCode Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetMetricsForZipCodeResultSet extends ResultSet {
		public GetMetricsForZipCodeResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Genability.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
