package com.temboo.Library.Twilio.Calls;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetLastCall

Retrieves the latest phone call made to or from the specified account.
*/
public class GetLastCall extends Choreography {

	/**
	Create a new instance of the GetLastCall Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetLastCall(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Twilio/Calls/GetLastCall"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetLastCallInputSet
	*/
	public GetLastCallInputSet newInputSet() {
		return new GetLastCallInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetLastCallResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetLastCallResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetLastCall
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetLastCallInputSet extends InputSet {
		/** 
		Set the value of the AccountSID input for this Choreo. 

		@param String - (required, string) The AccountSID provided when you signed up for a Twilio account.
		*/
		public void set_AccountSID(String value) {
			this.setInput("AccountSID", value);
		}


		/** 
		Set the value of the AuthToken input for this Choreo. 

		@param String - (required, string) The authorization token provided when you signed up for a Twilio account.
		*/
		public void set_AuthToken(String value) {
			this.setInput("AuthToken", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetLastCall Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetLastCallResultSet extends ResultSet {
		public GetLastCallResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Twilio.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
